/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudSubscriberFactory
implements SubscriberFactory {
    private static final Logger log = Logger.getLogger(CloudSubscriberFactory.class.getName());
    private final ConfigSource configSource;
    private final Map<CloudSubscriber, Integer> activeSubscribers = new WeakHashMap<CloudSubscriber, Integer>();
    private Optional<Long> testGeneration = Optional.empty();

    public CloudSubscriberFactory(ConfigSource configSource) {
        this.configSource = configSource;
    }

    @Override
    public Subscriber getSubscriber(Set<? extends ConfigKey<?>> configKeys) {
        HashSet<ConfigKey<ConfigInstance>> subscriptionKeys = new HashSet<ConfigKey<ConfigInstance>>();
        Iterator<ConfigKey<?>> iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            ConfigKey<?> key;
            ConfigKey<?> invariant = key = iterator.next();
            subscriptionKeys.add(invariant);
        }
        CloudSubscriber subscriber = new CloudSubscriber(subscriptionKeys, this.configSource);
        this.testGeneration.ifPresent(arg_0 -> ((ConfigSubscriber)subscriber.subscriber).reload(arg_0));
        this.activeSubscribers.put(subscriber, 0);
        return subscriber;
    }

    @Override
    public void reloadActiveSubscribers(long generation) {
        this.testGeneration = Optional.of(generation);
        ArrayList<CloudSubscriber> subscribers = new ArrayList<CloudSubscriber>(this.activeSubscribers.keySet());
        subscribers.forEach(s -> s.subscriber.reload(generation));
    }

    public static class Provider
    implements com.google.inject.Provider<SubscriberFactory> {
        public SubscriberFactory get() {
            return new CloudSubscriberFactory((ConfigSource)ConfigSourceSet.createDefault());
        }
    }

    private static class CloudSubscriber
    implements Subscriber {
        private final ConfigSubscriber subscriber;
        private final Map<ConfigKey<ConfigInstance>, ConfigHandle<ConfigInstance>> handles = new HashMap<ConfigKey<ConfigInstance>, ConfigHandle<ConfigInstance>>();
        private long generation = -1L;

        private CloudSubscriber(Set<ConfigKey<ConfigInstance>> keys, ConfigSource configSource) {
            this.subscriber = new ConfigSubscriber(configSource);
            keys.forEach(k -> this.handles.put((ConfigKey<ConfigInstance>)k, (ConfigHandle<ConfigInstance>)this.subscriber.subscribe(k.getConfigClass(), k.getConfigId())));
        }

        @Override
        public boolean configChanged() {
            return this.handles.values().stream().anyMatch(ConfigHandle::isChanged);
        }

        @Override
        public long generation() {
            return this.generation;
        }

        @Override
        public Map<ConfigKey<ConfigInstance>, ConfigInstance> config() {
            HashMap<ConfigKey<ConfigInstance>, ConfigInstance> ret = new HashMap<ConfigKey<ConfigInstance>, ConfigInstance>();
            this.handles.forEach((k, v) -> ret.put((ConfigKey<ConfigInstance>)k, v.getConfig()));
            return ret;
        }

        @Override
        public long waitNextGeneration(boolean isInitializing) {
            if (this.handles.isEmpty()) {
                throw new IllegalStateException("No config keys registered");
            }
            boolean gotNextGen = false;
            int numExceptions = 0;
            while (!gotNextGen) {
                try {
                    if (!this.subscriber.nextGeneration(isInitializing)) continue;
                    gotNextGen = true;
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.WARNING, "Got exception from the config system (ignore if you just removed a component from your application that used the mentioned config) Subscriber info: " + this.subscriber.toString(), e);
                    if (++numExceptions < 5) continue;
                    throw new IllegalArgumentException("Failed retrieving the next config generation", e);
                }
            }
            this.generation = this.subscriber.getGeneration();
            return this.generation;
        }

        @Override
        public void close() {
            this.subscriber.close();
        }
    }
}

