/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ComponentsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8acfd530c0587f3a7748f840bb262ae0";
    public static final String CONFIG_DEF_NAME = "components";
    public static final String CONFIG_DEF_NAMESPACE = "container";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container", "components[].id string", "components[].configId reference default=\":parent:\"", "components[].classId string default=\"\"", "components[].bundle string default=\"\"", "components[].inject[].id string", "components[].inject[].name string default=\"\""};
    private final InnerNodeVector<Components> components;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ComponentsConfig(Builder builder) {
        this(builder, true);
    }

    private ComponentsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for components must be initialized: " + builder.__uninitialized);
        }
        this.components = Components.createVector(builder.components);
    }

    public List<Components> components() {
        return this.components;
    }

    public Components components(int i) {
        return (Components)((Object)this.components.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ComponentsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Components
    extends InnerNode {
        private final StringNode id;
        private final ReferenceNode configId;
        private final StringNode classId;
        private final StringNode bundle;
        private final InnerNodeVector<Inject> inject;

        public Components(Builder builder) {
            this(builder, true);
        }

        private Components(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for components.components[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.configId = builder.configId == null ? new ReferenceNode(":parent:") : new ReferenceNode(builder.configId);
            this.classId = builder.classId == null ? new StringNode(ComponentsConfig.CONFIG_DEF_VERSION) : new StringNode(builder.classId);
            this.bundle = builder.bundle == null ? new StringNode(ComponentsConfig.CONFIG_DEF_VERSION) : new StringNode(builder.bundle);
            this.inject = Inject.createVector(builder.inject);
        }

        public String id() {
            return this.id.value();
        }

        public String configId() {
            return this.configId.value();
        }

        public String classId() {
            return this.classId.value();
        }

        public String bundle() {
            return this.bundle.value();
        }

        public List<Inject> inject() {
            return this.inject;
        }

        public Inject inject(int i) {
            return (Inject)((Object)this.inject.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Components newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart(ComponentsConfig.CONFIG_DEF_NAME);
            return changes;
        }

        private static InnerNodeVector<Components> createVector(List<Builder> builders) {
            ArrayList<Components> elems = new ArrayList<Components>();
            for (Builder b : builders) {
                elems.add(new Components(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Inject
        extends InnerNode {
            private final StringNode id;
            private final StringNode name;

            public Inject(Builder builder) {
                this(builder, true);
            }

            private Inject(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for components.components[].inject[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
                this.name = builder.name == null ? new StringNode(ComponentsConfig.CONFIG_DEF_VERSION) : new StringNode(builder.name);
            }

            public String id() {
                return this.id.value();
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Inject newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("inject");
                return changes;
            }

            private static InnerNodeVector<Inject> createVector(List<Builder> builders) {
                ArrayList<Inject> elems = new ArrayList<Inject>();
                for (Builder b : builders) {
                    elems.add(new Inject(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
                private String id = null;
                private String name = null;

                public Builder() {
                }

                public Builder(Inject config) {
                    this.id(config.id());
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder id(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    return this;
                }

                public Inject build() {
                    return new Inject(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
            private String id = null;
            private String configId = null;
            private String classId = null;
            private String bundle = null;
            public List<Inject.Builder> inject = new ArrayList<Inject.Builder>();

            public Builder() {
            }

            public Builder(Components config) {
                this.id(config.id());
                this.configId(config.configId());
                this.classId(config.classId());
                this.bundle(config.bundle());
                for (Inject i : config.inject()) {
                    this.inject(new Inject.Builder(i));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.configId != null) {
                    this.configId(__superior.configId);
                }
                if (__superior.classId != null) {
                    this.classId(__superior.classId);
                }
                if (__superior.bundle != null) {
                    this.bundle(__superior.bundle);
                }
                if (!__superior.inject.isEmpty()) {
                    this.inject.addAll(__superior.inject);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder configId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configId = __value;
                return this;
            }

            public Builder classId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.classId = __value;
                return this;
            }

            public Builder bundle(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.bundle = __value;
                return this;
            }

            public Builder inject(Inject.Builder __builder) {
                this.inject.add(__builder);
                return this;
            }

            public Builder inject(List<Inject.Builder> __builders) {
                this.inject = __builders;
                return this;
            }

            public Components build() {
                return new Components(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Components.Builder> components = new ArrayList<Components.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ComponentsConfig config) {
            for (Components c : config.components()) {
                this.components(new Components.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.components.isEmpty()) {
                this.components.addAll(__superior.components);
            }
            return this;
        }

        public Builder components(Components.Builder __builder) {
            this.components.add(__builder);
            return this;
        }

        public Builder components(List<Components.Builder> __builders) {
            this.components = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ComponentsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ComponentsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ComponentsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ComponentsConfig build() {
            return new ComponentsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

