/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.dependencies.ordering;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.dependencies.ordering.ComponentNameProvider;
import com.yahoo.component.chain.dependencies.ordering.ComponentNode;
import com.yahoo.component.chain.dependencies.ordering.ConflictingNodeTypeException;
import com.yahoo.component.chain.dependencies.ordering.CycleDependenciesException;
import com.yahoo.component.chain.dependencies.ordering.NameProvider;
import com.yahoo.component.chain.dependencies.ordering.Node;
import com.yahoo.component.chain.dependencies.ordering.OrderedReadyNodes;
import com.yahoo.component.chain.dependencies.ordering.PhaseNameProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ChainBuilder<T extends ChainedComponent> {
    private final ComponentId id;
    private int numComponents = 0;
    private int priority = 1;
    private Map<String, NameProvider> nameProviders = new LinkedHashMap<String, NameProvider>();
    private Node allPhase;

    public ChainBuilder(ComponentId id) {
        this.id = id;
        this.allPhase = this.addPhase(new Phase("*", this.set("*"), Collections.emptySet()));
    }

    private Set<String> set(String ... s) {
        return new HashSet<String>(Arrays.asList(s));
    }

    public PhaseNameProvider addPhase(Phase phase) {
        NameProvider nameProvider = this.nameProviders.get(phase.getName());
        if (nameProvider instanceof ComponentNameProvider) {
            throw new ConflictingNodeTypeException("Cannot add phase '" + phase.getName() + "' as it is already provided by " + nameProvider);
        }
        PhaseNameProvider phaseNameProvider = nameProvider == null ? new PhaseNameProvider(phase.getName(), this.priority++) : (PhaseNameProvider)nameProvider;
        this.nameProviders.put(phase.getName(), phaseNameProvider);
        for (String before : phase.before()) {
            phaseNameProvider.before(this.getPhaseNameProvider(before));
        }
        for (String after : phase.after()) {
            this.getPhaseNameProvider(after).before(phaseNameProvider);
        }
        return phaseNameProvider;
    }

    public void addComponent(ChainedComponent component) {
        ComponentNode<ChainedComponent> componentNode = new ComponentNode<ChainedComponent>(component, this.priority++);
        this.ensureProvidesNotEmpty(component);
        for (String name : component.getDependencies().provides()) {
            NameProvider nameProvider = this.getNameProvider(name);
            nameProvider.addNode(componentNode);
        }
        for (String before : component.getDependencies().before()) {
            componentNode.before(this.getNameProvider(before));
        }
        for (String after : component.getDependencies().after()) {
            this.getNameProvider(after).before(componentNode);
        }
        ++this.numComponents;
    }

    public Chain<T> orderNodes() {
        ArrayList chain = new ArrayList();
        OrderedReadyNodes readyNodes = this.getReadyNodes();
        while (!readyNodes.isEmpty() || this.popAllPhase(readyNodes)) {
            Node candidate = readyNodes.pop();
            candidate.removed(readyNodes);
            if (!(candidate instanceof ComponentNode)) continue;
            chain.add(((ComponentNode)candidate).getComponent());
        }
        if (chain.size() != this.numComponents) {
            throw new CycleDependenciesException(this.nameProviders);
        }
        this.nameProviders = null;
        return new Chain(this.id, chain);
    }

    private void ensureProvidesNotEmpty(ChainedComponent component) {
        if (component.getDependencies().provides().isEmpty()) {
            throw new RuntimeException("The component " + component.getId() + " did not provide anything.");
        }
    }

    private Node getPhaseNameProvider(String name) {
        NameProvider nameProvider = this.nameProviders.get(name);
        if (nameProvider != null) {
            return nameProvider;
        }
        nameProvider = new PhaseNameProvider(name, this.priority++);
        this.nameProviders.put(name, nameProvider);
        return nameProvider;
    }

    private boolean popAllPhase(OrderedReadyNodes readyNodes) {
        if (this.allPhase == null) {
            return false;
        }
        Node phase = this.allPhase;
        this.allPhase = null;
        phase.removed(readyNodes);
        return !readyNodes.isEmpty();
    }

    private NameProvider getNameProvider(String name) {
        NameProvider nameProvider = this.nameProviders.get(name);
        if (nameProvider != null) {
            return nameProvider;
        }
        nameProvider = new ComponentNameProvider(name);
        this.nameProviders.put(name, nameProvider);
        return nameProvider;
    }

    private OrderedReadyNodes getReadyNodes() {
        OrderedReadyNodes readyNodes = new OrderedReadyNodes();
        for (Node node : this.nameProviders.values()) {
            if (!node.ready()) continue;
            readyNodes.add(node);
        }
        return readyNodes;
    }
}

