/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.server.jetty.OneTimeRunnable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;

final class FilterInvokingPrintWriter
extends PrintWriter {
    private final PrintWriter delegate;
    private final OneTimeRunnable filterInvoker;

    public FilterInvokingPrintWriter(PrintWriter delegate, OneTimeRunnable filterInvoker) {
        super(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.throwAssertionError();
            }

            private void throwAssertionError() {
                throw new AssertionError((Object)(FilterInvokingPrintWriter.class.getName() + " failed to delegate to the underlying writer"));
            }

            @Override
            public void flush() throws IOException {
                this.throwAssertionError();
            }

            @Override
            public void close() throws IOException {
                this.throwAssertionError();
            }
        });
        this.delegate = delegate;
        this.filterInvoker = filterInvoker;
    }

    public String toString() {
        return this.getClass().getName() + " (" + super.toString() + ")";
    }

    private void runFilterIfFirstInvocation() {
        this.filterInvoker.runIfFirstInvocation();
    }

    @Override
    public void flush() {
        this.runFilterIfFirstInvocation();
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.runFilterIfFirstInvocation();
        this.delegate.close();
    }

    @Override
    public boolean checkError() {
        return this.delegate.checkError();
    }

    @Override
    public void write(int c) {
        this.runFilterIfFirstInvocation();
        this.delegate.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.runFilterIfFirstInvocation();
        this.delegate.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.runFilterIfFirstInvocation();
        this.delegate.write(buf);
    }

    @Override
    public void write(String s, int off, int len) {
        this.runFilterIfFirstInvocation();
        this.delegate.write(s, off, len);
    }

    @Override
    public void write(String s) {
        this.runFilterIfFirstInvocation();
        this.delegate.write(s);
    }

    @Override
    public void print(boolean b) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(b);
    }

    @Override
    public void print(char c) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(c);
    }

    @Override
    public void print(int i) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(i);
    }

    @Override
    public void print(long l) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(l);
    }

    @Override
    public void print(float f) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(f);
    }

    @Override
    public void print(double d) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(d);
    }

    @Override
    public void print(char[] s) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(s);
    }

    @Override
    public void print(String s) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(s);
    }

    @Override
    public void print(Object obj) {
        this.runFilterIfFirstInvocation();
        this.delegate.print(obj);
    }

    @Override
    public void println() {
        this.runFilterIfFirstInvocation();
        this.delegate.println();
    }

    @Override
    public void println(boolean x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(char x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(int x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(long x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(float x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(double x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(char[] x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(String x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public void println(Object x) {
        this.runFilterIfFirstInvocation();
        this.delegate.println(x);
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.runFilterIfFirstInvocation();
        return this.delegate.printf(format, args);
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.runFilterIfFirstInvocation();
        return this.delegate.printf(l, format, args);
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.runFilterIfFirstInvocation();
        return this.delegate.format(format, args);
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        this.runFilterIfFirstInvocation();
        return this.delegate.format(l, format, args);
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.runFilterIfFirstInvocation();
        return this.delegate.append(csq);
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.runFilterIfFirstInvocation();
        return this.delegate.append(csq, start, end);
    }

    @Override
    public PrintWriter append(char c) {
        this.runFilterIfFirstInvocation();
        return this.delegate.append(c);
    }
}

