/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.google.inject.Key;
import com.google.inject.util.Types;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ComponentRegistryNode
extends Node {
    private static ComponentId componentRegistryNamespace = ComponentId.fromString((String)"ComponentRegistry");
    private final Class<?> componentClass;

    public ComponentRegistryNode(Class<?> componentClass) {
        super(ComponentRegistryNode.componentId(componentClass));
        this.componentClass = componentClass;
    }

    @Override
    public List<Node> usedComponents() {
        return this.componentsToInject;
    }

    @Override
    protected Object newInstance() {
        ComponentRegistry registry = new ComponentRegistry();
        this.componentsToInject.forEach(component -> registry.register(component.componentId(), component.component()));
        return registry;
    }

    @Override
    public Key<?> instanceKey() {
        return Key.get((Type)Types.newParameterizedType(ComponentRegistry.class, (Type[])new Type[]{this.componentClass}));
    }

    @Override
    public Class<?> instanceType() {
        return this.instanceKey().getTypeLiteral().getRawType();
    }

    @Override
    public Class<?> componentType() {
        return this.instanceType();
    }

    public Class<?> componentClass() {
        return this.componentClass;
    }

    @Override
    public Set<ConfigKey<ConfigInstance>> configKeys() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.componentClass == null ? 0 : this.componentClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComponentRegistryNode) {
            ComponentRegistryNode that = (ComponentRegistryNode)other;
            return this.componentId().equals((Object)that.componentId()) && this.instanceType().equals(that.instanceType()) && ComponentRegistryNode.equalNodeEdges(this.usedComponents(), that.usedComponents());
        }
        return false;
    }

    @Override
    public String label() {
        return String.format("{ComponentRegistry\\<%s\\>|%s}", this.componentClass.getSimpleName(), Node.packageName(this.componentClass));
    }

    private static ComponentId componentId(Class<?> componentClass) {
        return ComponentRegistryNode.syntheticComponentId(componentClass.getName(), componentClass, componentRegistryNamespace);
    }

    public static boolean equalNodeEdges(List<Node> edges, List<Node> otherEdges) {
        if (edges.size() == otherEdges.size()) {
            List left = edges.stream().map(Node::componentId).sorted().collect(Collectors.toList());
            List right = otherEdges.stream().map(Node::componentId).sorted().collect(Collectors.toList());
            return left.equals(right);
        }
        return false;
    }
}

