/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.StringUtil;

public class ErrorResponseContentCreator {
    private final ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);

    public byte[] createErrorContent(String requestUri, int statusCode, Optional<String> message) {
        String sanitizedString = message.map(StringUtil::sanitizeXmlString).orElse("");
        String statusCodeString = Integer.toString(statusCode);
        this.writer.resetWriter();
        try {
            this.writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n<title>Error ");
            this.writer.write(statusCodeString);
            this.writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
            this.writer.write(statusCodeString);
            this.writer.write("</h2>\n<p>Problem accessing ");
            this.writer.write(StringUtil.sanitizeXmlString((String)requestUri));
            this.writer.write(". Reason:\n<pre>    ");
            this.writer.write(sanitizedString);
            this.writer.write("</pre></p>\n<hr/>\n</body>\n</html>\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.writer.getByteArray();
    }
}

