/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.di.Osgi;
import com.yahoo.container.di.componentgraph.core.ComponentNode;
import com.yahoo.container.di.config.JerseyBundlesConfig;
import com.yahoo.container.di.config.RestApiContext;
import com.yahoo.container.di.osgi.BundleClasses;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class JerseyNode
extends ComponentNode {
    private static final String WEB_INF_URL = "WebInfUrl";
    private final Osgi osgi;

    public JerseyNode(ComponentId componentId, String configId, Class<?> clazz, Osgi osgi) {
        super(componentId, configId, clazz, null);
        this.osgi = osgi;
    }

    @Override
    protected RestApiContext newInstance() {
        Object instance = super.newInstance();
        RestApiContext restApiContext = (RestApiContext)instance;
        List<JerseyBundlesConfig.Bundles> bundles = restApiContext.bundlesConfig.bundles();
        for (JerseyBundlesConfig.Bundles bundleConfig : bundles) {
            BundleClasses bundleClasses = this.osgi.getBundleClasses(ComponentSpecification.fromString((String)bundleConfig.spec()), new HashSet<String>(bundleConfig.packages()));
            restApiContext.addBundle(JerseyNode.createBundleInfo(bundleClasses.bundle(), bundleClasses.classEntries()));
        }
        this.componentsToInject.forEach(component -> restApiContext.addInjectableComponent(component.instanceKey(), component.componentId(), component.component()));
        return restApiContext;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof JerseyNode && this.componentsToInject.equals(((JerseyNode)other).componentsToInject);
    }

    public static RestApiContext.BundleInfo createBundleInfo(Bundle bundle, Collection<String> classEntries) {
        RestApiContext.BundleInfo bundleInfo = new RestApiContext.BundleInfo(bundle.getSymbolicName(), bundle.getVersion(), bundle.getLocation(), JerseyNode.webInfUrl(bundle), ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        bundleInfo.setClassEntries(classEntries);
        return bundleInfo;
    }

    public static Bundle getBundle(Osgi osgi, String bundleSpec) {
        Bundle bundle = osgi.getBundle(ComponentSpecification.fromString((String)bundleSpec));
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle not found: " + bundleSpec);
        }
        return bundle;
    }

    private static URL webInfUrl(Bundle bundle) {
        String webInfUrlHeader = (String)bundle.getHeaders().get(WEB_INF_URL);
        if (webInfUrlHeader == null) {
            return null;
        }
        return bundle.getEntry(webInfUrlHeader);
    }
}

