/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.response;

import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.request.ErrorMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FutureResponse
extends ForwardingFuture<Response> {
    private final Request request;
    private final Execution execution;
    private static final Logger log = Logger.getLogger(FutureResponse.class.getName());
    private final ListenableFutureTask<Response> futureTask;

    public FutureResponse(Callable<Response> callable, Execution execution, Request request) {
        this.futureTask = ListenableFutureTask.create(callable);
        this.request = request;
        this.execution = execution;
    }

    public ListenableFutureTask<Response> delegate() {
        return this.futureTask;
    }

    public Response get() {
        try {
            return (Response)((Object)super.get());
        }
        catch (InterruptedException e) {
            return new Response(this.request, new ErrorMessage("'" + this.execution + "' was interrupted", e));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception on executing " + this.execution + " for " + this.request, e);
            return new Response(this.request, new ErrorMessage("Error in '" + this.execution + "'", e));
        }
    }

    public Response get(long timeout, TimeUnit timeunit) {
        try {
            return (Response)((Object)super.get(timeout, timeunit));
        }
        catch (InterruptedException e) {
            return new Response(this.request, new ErrorMessage("'" + this.execution + "' was interrupted", e));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception on executing " + this.execution + " for " + this.request, e);
            return new Response(this.request, new ErrorMessage("Error in '" + this.execution + "'", e));
        }
        catch (TimeoutException e) {
            return new Response(this.request, new ErrorMessage("Error executing '" + this.execution + "':  Chain timed out."));
        }
    }

    public Request getRequest() {
        return this.request;
    }
}

