/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.DiscFilterResponse;
import com.yahoo.jdisc.http.filter.JdiscFilterResponse;
import com.yahoo.jdisc.http.filter.RequestView;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityResponseFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SecurityResponseFilterChain
extends AbstractResource
implements ResponseFilter {
    private final List<SecurityResponseFilter> filters = new ArrayList<SecurityResponseFilter>();

    private SecurityResponseFilterChain(Iterable<? extends SecurityResponseFilter> filters) {
        for (SecurityResponseFilter securityResponseFilter : filters) {
            this.filters.add(securityResponseFilter);
        }
    }

    @Override
    public void filter(Response response, Request request) {
        JdiscFilterResponse discFilterResponse = new JdiscFilterResponse(response);
        RequestViewImpl requestView = new RequestViewImpl(request);
        this.filter(requestView, discFilterResponse);
    }

    public void filter(RequestView requestView, DiscFilterResponse response) {
        for (SecurityResponseFilter filter : this.filters) {
            filter.filter(response, requestView);
        }
    }

    public static ResponseFilter newInstance(SecurityResponseFilter ... filters) {
        return SecurityResponseFilterChain.newInstance(Arrays.asList(filters));
    }

    public static ResponseFilter newInstance(List<? extends SecurityResponseFilter> filters) {
        return new SecurityResponseFilterChain(filters);
    }

    public List<SecurityResponseFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    static class RequestViewImpl
    implements RequestView {
        private final Request request;
        private final Optional<HttpRequest.Method> method;

        public RequestViewImpl(Request request) {
            this.request = request;
            this.method = request instanceof HttpRequest ? Optional.of(((HttpRequest)request).getMethod()) : Optional.empty();
        }

        @Override
        public Object getAttribute(String name) {
            return this.request.context().get(name);
        }

        @Override
        public List<String> getHeaders(String name) {
            List headers = this.request.headers().get((Object)name);
            return headers == null ? Collections.emptyList() : Collections.unmodifiableList(headers);
        }

        @Override
        public Optional<String> getFirstHeader(String name) {
            return this.getHeaders(name).stream().findFirst();
        }

        @Override
        public Optional<HttpRequest.Method> getMethod() {
            return this.method;
        }

        @Override
        public URI getUri() {
            return this.request.getUri();
        }
    }
}

