/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.CookieHelper;
import com.yahoo.jdisc.http.HttpResponse;
import com.yahoo.jdisc.http.filter.DiscFilterResponse;
import com.yahoo.jdisc.http.servlet.ServletOrJdiscHttpResponse;
import java.util.List;
import java.util.Map;

class JdiscFilterResponse
extends DiscFilterResponse {
    private final Response parent;

    JdiscFilterResponse(Response parent) {
        super(parent instanceof HttpResponse ? (HttpResponse)parent : new Adapter(parent));
        this.parent = parent;
    }

    @Override
    public void setStatus(int status) {
        this.parent.setStatus(status);
    }

    @Override
    public void setHeader(String name, String value) {
        this.parent.headers().put(name, value);
    }

    @Override
    public void removeHeaders(String name) {
        this.parent.headers().remove((Object)name);
    }

    @Override
    public void setHeaders(String name, String value) {
        this.parent.headers().put(name, value);
    }

    @Override
    public void setHeaders(String name, List<String> values) {
        this.parent.headers().put(name, values);
    }

    @Override
    public void addHeader(String name, String value) {
        this.parent.headers().add(name, value);
    }

    @Override
    public String getHeader(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(values.size() - 1);
    }

    @Override
    public void setCookies(List<Cookie> cookies) {
        CookieHelper.encodeSetCookieHeader(this.parent.headers(), cookies);
    }

    private static class Adapter
    implements ServletOrJdiscHttpResponse {
        private final Response response;

        Adapter(Response response) {
            this.response = response;
        }

        @Override
        public void copyHeaders(HeaderFields target) {
            target.addAll((Map)this.response.headers());
        }

        @Override
        public int getStatus() {
            return this.response.getStatus();
        }

        @Override
        public Map<String, Object> context() {
            return this.response.context();
        }

        @Override
        public List<Cookie> decodeSetCookieHeader() {
            return CookieHelper.decodeSetCookieHeader(this.response.headers());
        }
    }
}

