/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.osgi;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.osgi.maven.ProjectBundleClassPaths;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiUtil {
    private static final Logger log = Logger.getLogger(OsgiUtil.class.getName());
    private static final String CLASS_FILE_TYPE_SUFFIX = ".class";

    public static Collection<String> getClassEntriesInBundleClassPath(Bundle bundle, Set<String> packagesToScan) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (packagesToScan.isEmpty()) {
            return bundleWiring.listResources("/", "*.class", 3);
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String pkg : packagesToScan) {
            ret.addAll(bundleWiring.listResources(OsgiUtil.packageToPath(pkg), "*.class", 2));
        }
        return ret;
    }

    public static Collection<String> getClassEntriesForBundleUsingProjectClassPathMappings(ClassLoader classLoader, ComponentSpecification bundleSpec, Set<String> packagesToScan) {
        return OsgiUtil.classEntriesFrom(OsgiUtil.bundleClassPathMapping((ComponentSpecification)bundleSpec, (ClassLoader)classLoader).classPathElements, packagesToScan);
    }

    private static ProjectBundleClassPaths.BundleClasspathMapping bundleClassPathMapping(ComponentSpecification bundleSpec, ClassLoader classLoader) {
        ProjectBundleClassPaths projectBundleClassPaths = OsgiUtil.loadProjectBundleClassPaths(classLoader);
        if (projectBundleClassPaths.mainBundle.bundleSymbolicName.equals(bundleSpec.getName())) {
            return projectBundleClassPaths.mainBundle;
        }
        log.log(Level.WARNING, "Dependencies of the bundle " + bundleSpec + " will not be scanned. Please file a feature request if you need this");
        return OsgiUtil.matchingBundleClassPathMapping(bundleSpec, projectBundleClassPaths.providedDependencies);
    }

    public static ProjectBundleClassPaths.BundleClasspathMapping matchingBundleClassPathMapping(ComponentSpecification bundleSpec, Collection<ProjectBundleClassPaths.BundleClasspathMapping> providedBundlesClassPathMappings) {
        for (ProjectBundleClassPaths.BundleClasspathMapping mapping : providedBundlesClassPathMappings) {
            if (!mapping.bundleSymbolicName.equals(bundleSpec.getName())) continue;
            return mapping;
        }
        throw new RuntimeException("No such bundle: " + bundleSpec);
    }

    private static ProjectBundleClassPaths loadProjectBundleClassPaths(ClassLoader classLoader) {
        URL classPathMappingsFileLocation = classLoader.getResource("bundle-plugin.bundle-classpath-mappings.json");
        if (classPathMappingsFileLocation == null) {
            throw new RuntimeException("Couldn't find bundle-plugin.bundle-classpath-mappings.json  in the class path.");
        }
        try {
            return ProjectBundleClassPaths.load((Path)Paths.get(classPathMappingsFileLocation.toURI()));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Collection<String> classEntriesFrom(List<String> classPathEntries, Set<String> packagesToScan) {
        Set<String> packagePathsToScan = packagesToScan.stream().map(OsgiUtil::packageToPath).collect(Collectors.toSet());
        ArrayList<String> ret = new ArrayList<String>();
        for (String entry : classPathEntries) {
            Path path = Paths.get(entry, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                ret.addAll(OsgiUtil.classEntriesInPath(path, packagePathsToScan));
                continue;
            }
            if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar")) {
                ret.addAll(OsgiUtil.classEntriesInJar(path, packagePathsToScan));
                continue;
            }
            throw new RuntimeException("Unsupported path " + path + " in the class path");
        }
        return ret;
    }

    private static String relativePathToClass(Path rootPath, Path pathToClass) {
        Path relativePath = rootPath.relativize(pathToClass);
        return relativePath.toString();
    }

    private static Collection<String> classEntriesInPath(Path rootPath, Collection<String> packagePathsToScan) {
        Object fileIterator;
        if (packagePathsToScan.isEmpty()) {
            fileIterator = com.google.common.io.Files.fileTreeTraverser().preOrderTraversal((Object)rootPath.toFile());
        } else {
            ArrayList<File> files = new ArrayList<File>();
            for (String packagePath : packagePathsToScan) {
                for (File file : com.google.common.io.Files.fileTreeTraverser().children((Object)rootPath.resolve(packagePath).toFile())) {
                    files.add(file);
                }
            }
            fileIterator = files;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (File file : fileIterator) {
            if (!file.isFile() || !file.getName().endsWith(CLASS_FILE_TYPE_SUFFIX)) continue;
            ret.add(OsgiUtil.relativePathToClass(rootPath, file.toPath()));
        }
        return ret;
    }

    private static String packagePath(String name) {
        int index = name.lastIndexOf(47);
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    private static Collection<String> classEntriesInJar(Path jarPath, Set<String> packagePathsToScan) {
        Collection collection;
        Predicate<String> acceptedPackage = packagePathsToScan.isEmpty() ? ign -> true : name -> packagePathsToScan.contains(OsgiUtil.packagePath(name));
        JarFile jarFile = new JarFile(jarPath.toFile());
        try {
            collection = jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(CLASS_FILE_TYPE_SUFFIX)).filter(acceptedPackage).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        jarFile.close();
        return collection;
    }

    private static String packageToPath(String packageName) {
        return packageName.replace('.', '/');
    }
}

