/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Preconditions;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

class ServletRequestReader
implements ReadListener {
    private static final Logger log = Logger.getLogger(ServletRequestReader.class.getName());
    private static final int BUFFER_SIZE_BYTES = 8192;
    private final Object monitor = new Object();
    private final ServletInputStream servletInputStream;
    private final ContentChannel requestContentChannel;
    private final Executor executor;
    private final RequestMetricReporter metricReporter;
    private int bytesRead;
    private State state = State.READING;
    private int numberOfOutstandingUserCalls = 0;
    final CompletableFuture<Void> finishedFuture = new CompletableFuture();
    private final CompletionHandler writeCompletionHandler = new CompletionHandler(){

        public void completed() {
            ServletRequestReader.this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
        }

        public void failed(Throwable t) {
            ServletRequestReader.this.finishedFuture.completeExceptionally(t);
            ServletRequestReader.this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
        }
    };

    public ServletRequestReader(ServletInputStream servletInputStream, ContentChannel requestContentChannel, Executor executor, RequestMetricReporter metricReporter) {
        Preconditions.checkNotNull((Object)servletInputStream);
        Preconditions.checkNotNull((Object)requestContentChannel);
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)metricReporter);
        this.servletInputStream = servletInputStream;
        this.requestContentChannel = requestContentChannel;
        this.executor = executor;
        this.metricReporter = metricReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataAvailable() throws IOException {
        while (this.servletInputStream.isReady()) {
            int numBytesRead;
            byte[] buffer = new byte[8192];
            Object object = this.monitor;
            synchronized (object) {
                numBytesRead = this.servletInputStream.read(buffer);
                if (numBytesRead < 0) {
                    return;
                }
                if (this.state != State.READING) {
                    assert (this.finishedFuture.isCompletedExceptionally());
                    return;
                }
                this.numberOfOutstandingUserCalls += 2;
                this.bytesRead += numBytesRead;
            }
            try {
                this.requestContentChannel.write(ByteBuffer.wrap(buffer, 0, numBytesRead), this.writeCompletionHandler);
                this.metricReporter.successfulRead(numBytesRead);
            }
            catch (Throwable t) {
                this.finishedFuture.completeExceptionally(t);
            }
            finally {
                this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally() {
        boolean shouldCloseRequestContentChannel;
        Object object = this.monitor;
        synchronized (object) {
            this.assertStateNotEquals(this.state, State.REQUEST_CONTENT_CLOSED);
            --this.numberOfOutstandingUserCalls;
            boolean bl = shouldCloseRequestContentChannel = this.numberOfOutstandingUserCalls == 0 && (this.finishedFuture.isDone() || this.state == State.ALL_DATA_READ);
            if (shouldCloseRequestContentChannel) {
                this.state = State.REQUEST_CONTENT_CLOSED;
            }
        }
        if (shouldCloseRequestContentChannel) {
            this.executor.execute(this::closeCompletionHandler_noThrow);
        }
    }

    private void assertStateNotEquals(State state, State notExpectedState) {
        if (state == notExpectedState) {
            AssertionError e = new AssertionError((Object)("State should not be " + notExpectedState));
            log.log(Level.WARNING, "Assertion failed. numberOfOutstandingUserCalls = " + this.numberOfOutstandingUserCalls + ", isDone = " + this.finishedFuture.isDone(), (Throwable)((Object)e));
            throw e;
        }
    }

    public void onAllDataRead() {
        this.doneReading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneReading() {
        int bytesRead;
        boolean shouldCloseRequestContentChannel;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state != State.READING) {
                return;
            }
            this.state = State.ALL_DATA_READ;
            boolean bl = shouldCloseRequestContentChannel = this.numberOfOutstandingUserCalls == 0;
            if (shouldCloseRequestContentChannel) {
                this.state = State.REQUEST_CONTENT_CLOSED;
            }
            bytesRead = this.bytesRead;
        }
        if (shouldCloseRequestContentChannel) {
            this.closeCompletionHandler_noThrow();
        }
        this.metricReporter.contentSize(bytesRead);
    }

    private void closeCompletionHandler_noThrow() {
        final CompletableFuture completedCalledFuture = new CompletableFuture();
        CompletionHandler closeCompletionHandler = new CompletionHandler(){

            public void completed() {
                completedCalledFuture.complete(null);
            }

            public void failed(Throwable t) {
                ServletRequestReader.this.finishedFuture.completeExceptionally(t);
            }
        };
        try {
            this.requestContentChannel.close(closeCompletionHandler);
            completedCalledFuture.whenComplete(this::setFinishedFuture);
        }
        catch (Throwable t) {
            this.finishedFuture.completeExceptionally(t);
        }
    }

    private void setFinishedFuture(Void result, Throwable throwable) {
        if (throwable != null) {
            this.finishedFuture.completeExceptionally(throwable);
        } else {
            this.finishedFuture.complete(null);
        }
    }

    public void onError(Throwable t) {
        this.finishedFuture.completeExceptionally(t);
        this.doneReading();
    }

    private static enum State {
        READING,
        ALL_DATA_READ,
        REQUEST_CONTENT_CLOSED;

    }
}

