/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.google.common.annotations.Beta;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.RequestView;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilterChain;
import com.yahoo.jdisc.http.filter.SecurityResponseFilterChain;
import com.yahoo.jdisc.http.filter.ServletFilterRequest;
import com.yahoo.jdisc.http.filter.ServletFilterResponse;
import com.yahoo.jdisc.http.server.jetty.FilterInvoker;
import com.yahoo.jdisc.http.servlet.ServletRequest;
import com.yahoo.jdisc.http.servlet.ServletResponse;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Beta
public class SecurityFilterInvoker
implements FilterInvoker {
    @Override
    public HttpServletRequest invokeRequestFilterChain(RequestFilter requestFilterChain, URI uri, HttpServletRequest httpRequest, ResponseHandler responseHandler) {
        SecurityRequestFilterChain securityChain = this.cast(SecurityRequestFilterChain.class, requestFilterChain).orElseThrow(SecurityFilterInvoker::newUnsupportedOperationException);
        ServletRequest wrappedRequest = new ServletRequest(httpRequest, uri);
        securityChain.filter(new ServletFilterRequest(wrappedRequest), responseHandler);
        return wrappedRequest;
    }

    @Override
    public void invokeResponseFilterChain(ResponseFilter responseFilterChain, URI uri, HttpServletRequest request, HttpServletResponse response) {
        SecurityResponseFilterChain securityChain = this.cast(SecurityResponseFilterChain.class, responseFilterChain).orElseThrow(SecurityFilterInvoker::newUnsupportedOperationException);
        ServletFilterResponse wrappedResponse = new ServletFilterResponse(new ServletResponse(response));
        securityChain.filter(new ServletRequestView(uri, request), wrappedResponse);
    }

    private static UnsupportedOperationException newUnsupportedOperationException() {
        return new UnsupportedOperationException("Filter type not supported. If a request is handled by servlets or jax-rs, then any filters invoked for that request must be security filters.");
    }

    private <T> Optional<T> cast(Class<T> securityFilterChainClass, Object filter) {
        return securityFilterChainClass.isInstance(filter) ? Optional.of(securityFilterChainClass.cast(filter)) : Optional.empty();
    }

    private static class ServletRequestView
    implements RequestView {
        private final HttpServletRequest request;
        private final URI uri;

        public ServletRequestView(URI uri, HttpServletRequest request) {
            this.request = request;
            this.uri = uri;
        }

        @Override
        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        @Override
        public List<String> getHeaders(String name) {
            return Collections.unmodifiableList(Collections.list(this.request.getHeaders(name)));
        }

        @Override
        public Optional<String> getFirstHeader(String name) {
            return this.getHeaders(name).stream().findFirst();
        }

        @Override
        public Optional<HttpRequest.Method> getMethod() {
            return Optional.of(HttpRequest.Method.valueOf(this.request.getMethod()));
        }

        @Override
        public URI getUri() {
            return this.uri;
        }
    }
}

