/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.execution;

import com.yahoo.collections.Pair;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.util.Iterator;

public class Execution {
    private int processorIndex;
    private final Chain<? extends Processor> chain;
    private final Trace trace;
    private final Environment<? extends Processor> environment;

    public Execution(Processor processor, Execution execution) {
        this(new Chain((ChainedComponent[])new Processor[]{processor}), execution);
    }

    public static Execution createRoot(Processor processor, int traceLevel, Environment<? extends Processor> environment) {
        return Execution.createRoot(new Chain((ChainedComponent[])new Processor[]{processor}), traceLevel, environment);
    }

    public static Execution createRoot(Chain<? extends Processor> chain, int traceLevel, Environment<? extends Processor> environment) {
        return new Execution(chain, 0, Trace.createRoot(traceLevel), environment);
    }

    public Execution(Chain<? extends Processor> chain, Execution execution) {
        this(chain, 0, execution.trace().createChild(), execution.environment().nested());
    }

    public Execution(Execution startPoint) {
        this(startPoint.chain, startPoint.processorIndex, startPoint.trace.createChild(), startPoint.environment().nested());
    }

    protected Execution(Chain<? extends Processor> chain, int startIndex, Trace trace, Environment<? extends Processor> environment) {
        if (chain == null) {
            throw new NullPointerException("Chain cannot be null");
        }
        this.chain = chain;
        this.processorIndex = startIndex;
        this.trace = trace;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response process(Request request) {
        Processor processor = this.next();
        if (processor == null) {
            return this.defaultResponse(request);
        }
        Response response = null;
        try {
            this.nextProcessor();
            this.onInvoking(request, processor);
            response = processor.process(request, this);
            if (response == null) {
                throw new NullPointerException(processor + " returned null, not a Response object");
            }
            Response response2 = response;
            this.previousProcessor();
            this.onReturning(request, processor, response);
            return response2;
        }
        catch (Throwable throwable) {
            this.previousProcessor();
            this.onReturning(request, processor, response);
            throw throwable;
        }
    }

    protected int nextIndex() {
        return this.processorIndex;
    }

    protected void onInvoking(Request request, Processor next) {
        if (Trace.Level.Step.includes(this.trace.getTraceLevel()) || this.trace.getForceTimestamps()) {
            int traceAt = this.trace.getForceTimestamps() ? 1 : this.trace.getTraceLevel();
            this.trace.trace("Invoke " + next, traceAt);
        }
        if (Trace.Level.Dependencies.includes(this.trace.getTraceLevel())) {
            this.trace.trace(next.getId() + " " + next.getDependencies().toString(), this.trace.getTraceLevel());
        }
    }

    protected void onReturning(Request request, Processor processor, Response response) {
        if (Trace.Level.Step.includes(this.trace.getTraceLevel()) || this.trace.getForceTimestamps()) {
            int traceAt = this.trace.getForceTimestamps() ? 1 : this.trace.getTraceLevel();
            this.trace.trace("Return " + processor, traceAt);
        }
    }

    protected void previousProcessor() {
        --this.processorIndex;
    }

    protected void nextProcessor() {
        ++this.processorIndex;
    }

    protected Processor next() {
        if (this.chain.components().size() <= this.processorIndex) {
            return null;
        }
        return this.chain.components().get(this.processorIndex);
    }

    public Chain<? extends Processor> chain() {
        return this.chain;
    }

    protected Response defaultResponse(Request request) {
        return new Response(request);
    }

    public String toString() {
        return "execution of chain '" + this.chain.getId() + "'";
    }

    public Trace trace() {
        return this.trace;
    }

    public Environment<? extends Processor> environment() {
        return this.environment;
    }

    public static class Trace {
        private final TraceNode traceNode;
        private int traceLevel;
        private boolean forceTimestamps;

        public static Trace createRoot(int traceLevel) {
            return new Trace(traceLevel, new TraceNode(null, Trace.timestamp(traceLevel, false)), false);
        }

        public Trace createChild() {
            TraceNode child = new TraceNode(null, Trace.timestamp(this.traceLevel, this.forceTimestamps));
            this.traceNode.add(child);
            return new Trace(this.getTraceLevel(), child, this.forceTimestamps);
        }

        private Trace(int traceLevel, TraceNode traceNode, boolean forceTimestamps) {
            this.traceLevel = traceLevel;
            this.traceNode = traceNode;
            this.forceTimestamps = forceTimestamps;
        }

        public int getTraceLevel() {
            return this.traceLevel;
        }

        public void setTraceLevel(int traceLevel) {
            this.traceLevel = traceLevel;
        }

        public void setForceTimestamps(boolean forceTimestamps) {
            this.forceTimestamps = forceTimestamps;
        }

        public boolean getForceTimestamps() {
            return this.forceTimestamps;
        }

        public void trace(String message, int traceLevel) {
            this.trace((Object)message, traceLevel);
        }

        public void trace(Object message, int traceLevel) {
            if (this.traceLevel >= traceLevel) {
                this.traceNode.add(new TraceNode(message, Trace.timestamp(traceLevel, this.forceTimestamps)));
            }
        }

        public void logValue(String key, String value) {
            this.traceNode.add(new TraceNode((Object)new LogValue(key, value), 0L));
        }

        public Iterator<LogValue> logValueIterator() {
            return this.traceNode.root().descendants(LogValue.class).iterator();
        }

        public <VISITOR extends TraceVisitor> VISITOR accept(VISITOR visitor) {
            return (VISITOR)this.traceNode.root().accept(visitor);
        }

        public void setProperty(String name, Object value) {
            this.traceNode.add(new TraceNode((Object)new Pair((Object)name, value), 0L));
        }

        public Object getProperty(String name) {
            return this.accept(new PropertyValueVisitor(name)).foundValue();
        }

        public TraceNode traceNode() {
            return this.traceNode;
        }

        public String toString() {
            return "trace: " + this.traceNode;
        }

        private static long timestamp(int traceLevel, boolean forceTimestamps) {
            return forceTimestamps || Level.Timestamp.includes(traceLevel) ? System.currentTimeMillis() : 0L;
        }

        public static enum Level {
            Step(4),
            Timestamp(6),
            Dependencies(7);

            private int value;

            private Level(int value) {
                this.value = value;
            }

            public int value() {
                return this.value;
            }

            public boolean includes(int traceLevel) {
                return traceLevel >= this.value();
            }
        }

        public static class LogValue {
            private final String key;
            private final String value;

            public LogValue(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.key + "=" + this.value;
            }
        }

        private static class PropertyValueVisitor
        extends TraceVisitor {
            private String name;
            private Object foundValue = null;

            public PropertyValueVisitor(String name) {
                this.name = name;
            }

            public void visit(TraceNode node) {
                if (node.payload() == null) {
                    return;
                }
                if (!(node.payload() instanceof Pair)) {
                    return;
                }
                Pair property = (Pair)node.payload();
                if (!property.getFirst().equals(this.name)) {
                    return;
                }
                this.foundValue = property.getSecond();
            }

            public Object foundValue() {
                return this.foundValue;
            }
        }
    }

    public static class Environment<COMPONENT extends Processor> {
        private final ChainRegistry<COMPONENT> chainRegistry;

        public static <C extends Processor> Environment<C> createEmpty() {
            return new Environment(new ChainRegistry());
        }

        public Environment<COMPONENT> nested() {
            return this;
        }

        public Environment(ChainRegistry<COMPONENT> chainRegistry) {
            this.chainRegistry = chainRegistry;
        }

        public ChainRegistry<COMPONENT> chainRegistry() {
            return this.chainRegistry;
        }
    }
}

