/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadLocalDirectory;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.metrics.ManagerConfig;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.MetricAggregator;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.MetricUpdater;
import com.yahoo.metrics.simple.Sample;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetricManager
extends AbstractComponent
implements Provider<MetricReceiver> {
    private static Logger log = Logger.getLogger(MetricManager.class.getName());
    private final ScheduledThreadPoolExecutor executor;
    private final MetricReceiver receiver;
    private ThreadLocalDirectory<Bucket, Sample> metricsCollection;

    public MetricManager(ManagerConfig settings) {
        this(settings, new MetricUpdater());
    }

    private MetricManager(ManagerConfig settings, ThreadLocalDirectory.Updater<Bucket, Sample> updater) {
        log.log(Level.CONFIG, "setting up simple metrics gathering. reportPeriodSeconds=" + settings.reportPeriodSeconds() + ", pointsToKeepPerMetric=" + settings.pointsToKeepPerMetric());
        this.metricsCollection = new ThreadLocalDirectory(updater);
        AtomicReference<Object> currentSnapshot = new AtomicReference<Object>(null);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.scheduleAtFixedRate(new MetricAggregator(this.metricsCollection, currentSnapshot, settings), 1L, 1L, TimeUnit.SECONDS);
        this.receiver = new MetricReceiver(this.metricsCollection, currentSnapshot);
    }

    static MetricManager constructWithCustomUpdater(ManagerConfig settings, ThreadLocalDirectory.Updater<Bucket, Sample> updater) {
        return new MetricManager(settings, updater);
    }

    public void deconstruct() {
        this.executor.shutdown();
    }

    public MetricReceiver get() {
        return this.receiver;
    }
}

