/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Preconditions;
import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import java.util.Map;
import java.util.Optional;

public class AccessLoggingRequestHandler
extends AbstractRequestHandler {
    public static final String CONTEXT_KEY_ACCESS_LOG_ENTRY = AccessLoggingRequestHandler.class.getName() + "_access-log-entry";
    private final RequestHandler delegate;
    private final AccessLogEntry accessLogEntry;

    public static Optional<AccessLogEntry> getAccessLogEntry(HttpRequest jdiscRequest) {
        Map requestContextMap = jdiscRequest.context();
        return AccessLoggingRequestHandler.getAccessLogEntry(requestContextMap);
    }

    public static Optional<AccessLogEntry> getAccessLogEntry(Map<String, Object> requestContextMap) {
        return Optional.ofNullable((AccessLogEntry)requestContextMap.get(CONTEXT_KEY_ACCESS_LOG_ENTRY));
    }

    public AccessLoggingRequestHandler(RequestHandler delegateRequestHandler, AccessLogEntry accessLogEntry) {
        this.delegate = delegateRequestHandler;
        this.accessLogEntry = accessLogEntry;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        Preconditions.checkArgument((boolean)(request instanceof HttpRequest), (Object)("Expected HttpRequest, got " + request));
        HttpRequest httpRequest = (HttpRequest)request;
        httpRequest.context().put(CONTEXT_KEY_ACCESS_LOG_ENTRY, this.accessLogEntry);
        return this.delegate.handleRequest(request, handler);
    }
}

