/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Response;
import com.yahoo.processing.execution.Execution;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

public abstract class HttpResponse {
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private final Response parentResponse;

    public HttpResponse(int status) {
        this.parentResponse = com.yahoo.jdisc.http.HttpResponse.newInstance((int)status);
    }

    public abstract void render(OutputStream var1) throws IOException;

    public int getStatus() {
        return this.parentResponse.getStatus();
    }

    public void setStatus(int status) {
        this.parentResponse.setStatus(status);
    }

    public HeaderFields headers() {
        return this.parentResponse.headers();
    }

    public Response getJdiscResponse() {
        return this.parentResponse;
    }

    public String getContentType() {
        return DEFAULT_MIME_TYPE;
    }

    public String getCharacterEncoding() {
        return DEFAULT_CHARACTER_ENCODING;
    }

    public void populateAccessLogEntry(AccessLogEntry accessLogEntry) {
        for (Execution.Trace.LogValue logValue : this.getLogValues()) {
            accessLogEntry.addKeyValue(logValue.getKey(), logValue.getValue());
        }
    }

    public void complete() {
    }

    public Iterable<Execution.Trace.LogValue> getLogValues() {
        return Collections::emptyIterator;
    }
}

