/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ConnectionLogConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "690d033921d141b640802e1eae5f5dd3";
    public static final String CONFIG_DEF_NAME = "connection-log";
    public static final String CONFIG_DEF_NAMESPACE = "container.logging";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.logging", "cluster string", "logDirectoryName string default=\"qrs\"", "queueSize int default=10000"};
    private final StringNode cluster;
    private final StringNode logDirectoryName;
    private final IntegerNode queueSize;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ConnectionLogConfig(Builder builder) {
        this(builder, true);
    }

    private ConnectionLogConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for connection-log must be initialized: " + builder.__uninitialized);
        }
        this.cluster = builder.cluster == null ? new StringNode() : new StringNode(builder.cluster);
        this.logDirectoryName = builder.logDirectoryName == null ? new StringNode("qrs") : new StringNode(builder.logDirectoryName);
        this.queueSize = builder.queueSize == null ? new IntegerNode(10000) : new IntegerNode(builder.queueSize.intValue());
    }

    public String cluster() {
        return this.cluster.value();
    }

    public String logDirectoryName() {
        return this.logDirectoryName.value();
    }

    public int queueSize() {
        return this.queueSize.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ConnectionLogConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("cluster"));
        private String cluster = null;
        private String logDirectoryName = null;
        private Integer queueSize = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ConnectionLogConfig config) {
            this.cluster(config.cluster());
            this.logDirectoryName(config.logDirectoryName());
            this.queueSize(config.queueSize());
        }

        private Builder override(Builder __superior) {
            if (__superior.cluster != null) {
                this.cluster(__superior.cluster);
            }
            if (__superior.logDirectoryName != null) {
                this.logDirectoryName(__superior.logDirectoryName);
            }
            if (__superior.queueSize != null) {
                this.queueSize(__superior.queueSize);
            }
            return this;
        }

        public Builder cluster(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.cluster = __value;
            this.__uninitialized.remove("cluster");
            return this;
        }

        public Builder logDirectoryName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.logDirectoryName = __value;
            return this;
        }

        public Builder queueSize(int __value) {
            this.queueSize = __value;
            return this;
        }

        private Builder queueSize(String __value) {
            return this.queueSize(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ConnectionLogConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ConnectionLogConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ConnectionLogConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ConnectionLogConfig build() {
            return new ConnectionLogConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

