/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.RestApiImpl;
import com.yahoo.restapi.UriBuilder;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public interface RestApi {
    public static Builder builder() {
        return new RestApiImpl.BuilderImpl();
    }

    public static RouteBuilder route(String pathPattern) {
        return new RestApiImpl.RouteBuilderImpl(pathPattern);
    }

    public HttpResponse handleRequest(HttpRequest var1);

    public static interface FilterContext {
        public RequestContext requestContext();

        public String route();

        public HttpResponse executeNext();
    }

    public static interface RequestContext {
        public HttpRequest request();

        public PathParameters pathParameters();

        public QueryParameters queryParameters();

        public Headers headers();

        public Attributes attributes();

        public Optional<RequestContent> requestContent();

        public RequestContent requestContentOrThrow();

        public ObjectMapper jacksonJsonMapper();

        public UriBuilder uriBuilder();

        public static interface RequestContent {
            public String contentType();

            public InputStream content();
        }

        public static interface Attributes {
            public Optional<Object> get(String var1);

            public void set(String var1, Object var2);
        }

        public static interface Headers
        extends Parameters {
        }

        public static interface QueryParameters
        extends Parameters {
            public List<String> getStringList(String var1);
        }

        public static interface PathParameters
        extends Parameters {
        }

        public static interface Parameters {
            public Optional<String> getString(String var1);

            public String getStringOrThrow(String var1);

            default public Optional<Boolean> getBoolean(String name) {
                return this.getString(name).map(Boolean::valueOf);
            }

            default public boolean getBooleanOrThrow(String name) {
                return Boolean.parseBoolean(this.getStringOrThrow(name));
            }

            default public OptionalLong getLong(String name) {
                return this.getString(name).map(Long::parseLong).map(OptionalLong::of).orElseGet(OptionalLong::empty);
            }

            default public long getLongOrThrow(String name) {
                return Long.parseLong(this.getStringOrThrow(name));
            }

            default public OptionalDouble getDouble(String name) {
                return this.getString(name).map(Double::parseDouble).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
            }

            default public double getDoubleOrThrow(String name) {
                return Double.parseDouble(this.getStringOrThrow(name));
            }
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public HttpResponse filterRequest(FilterContext var1);
    }

    @FunctionalInterface
    public static interface RequestMapper<REQUEST_ENTITY> {
        public Optional<REQUEST_ENTITY> toRequestEntity(RequestContext var1) throws RestApiException;
    }

    @FunctionalInterface
    public static interface ResponseMapper<RESPONSE_ENTITY> {
        public HttpResponse toHttpResponse(RequestContext var1, RESPONSE_ENTITY var2) throws RestApiException;
    }

    @FunctionalInterface
    public static interface ExceptionMapper<EXCEPTION extends RuntimeException> {
        public HttpResponse toResponse(RequestContext var1, EXCEPTION var2);
    }

    @FunctionalInterface
    public static interface HandlerWithRequestEntity<REQUEST_ENTITY, RESPONSE_ENTITY> {
        public RESPONSE_ENTITY handleRequest(RequestContext var1, REQUEST_ENTITY var2) throws RestApiException;
    }

    @FunctionalInterface
    public static interface Handler<RESPONSE_ENTITY> {
        public RESPONSE_ENTITY handleRequest(RequestContext var1) throws RestApiException;
    }

    public static interface RouteBuilder {
        public RouteBuilder name(String var1);

        public RouteBuilder get(Handler<?> var1);

        public RouteBuilder post(Handler<?> var1);

        public <REQUEST_ENTITY> RouteBuilder post(Class<REQUEST_ENTITY> var1, HandlerWithRequestEntity<REQUEST_ENTITY, ?> var2);

        public RouteBuilder put(Handler<?> var1);

        public <REQUEST_ENTITY> RouteBuilder put(Class<REQUEST_ENTITY> var1, HandlerWithRequestEntity<REQUEST_ENTITY, ?> var2);

        public RouteBuilder delete(Handler<?> var1);

        public RouteBuilder patch(Handler<?> var1);

        public <REQUEST_ENTITY> RouteBuilder patch(Class<REQUEST_ENTITY> var1, HandlerWithRequestEntity<REQUEST_ENTITY, ?> var2);

        public RouteBuilder defaultHandler(Handler<?> var1);

        public <REQUEST_ENTITY> RouteBuilder defaultHandler(Class<REQUEST_ENTITY> var1, HandlerWithRequestEntity<REQUEST_ENTITY, ?> var2);

        public RouteBuilder addFilter(Filter var1);
    }

    public static interface Builder {
        public Builder setObjectMapper(ObjectMapper var1);

        public Builder setDefaultRoute(RouteBuilder var1);

        public Builder addRoute(RouteBuilder var1);

        public Builder addFilter(Filter var1);

        public <EXCEPTION extends RuntimeException> Builder addExceptionMapper(Class<EXCEPTION> var1, ExceptionMapper<EXCEPTION> var2);

        public <RESPONSE_ENTITY> Builder addResponseMapper(Class<RESPONSE_ENTITY> var1, ResponseMapper<RESPONSE_ENTITY> var2);

        public <REQUEST_ENTITY> Builder addRequestMapper(Class<REQUEST_ENTITY> var1, RequestMapper<REQUEST_ENTITY> var2);

        public <RESPONSE_ENTITY> Builder registerJacksonResponseEntity(Class<RESPONSE_ENTITY> var1);

        public <REQUEST_ENTITY> Builder registerJacksonRequestEntity(Class<REQUEST_ENTITY> var1);

        public Builder disableDefaultExceptionMappers();

        public Builder disableDefaultResponseMappers();

        public RestApi build();
    }
}

