/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.OverloadException;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.AccessLoggingRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FilteringRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FormPostRequestHandler;
import com.yahoo.jdisc.http.server.jetty.HttpRequestFactory;
import com.yahoo.jdisc.http.server.jetty.HttpServletRequestUtils;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscHttpServlet;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.ServletRequestReader;
import com.yahoo.jdisc.http.server.jetty.ServletResponseController;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpConnection;

class HttpRequestDispatch {
    private static final Logger log = Logger.getLogger(HttpRequestDispatch.class.getName());
    private static final String CHARSET_ANNOTATION = ";charset=";
    private final JDiscContext jDiscContext;
    private final AsyncContext async;
    private final org.eclipse.jetty.server.Request jettyRequest;
    private final ServletResponseController servletResponseController;
    private final RequestHandler requestHandler;
    private final RequestMetricReporter metricReporter;
    private final BiConsumer<Void, Throwable> completeRequestCallback;

    public HttpRequestDispatch(JDiscContext jDiscContext, AccessLogEntry accessLogEntry, Metric.Context metricContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        AtomicBoolean completeRequestCalled = new AtomicBoolean(false);
        HttpRequestDispatch parent = this;
        this.completeRequestCallback = (result, error) -> {
            boolean alreadyCalled = completeRequestCalled.getAndSet(true);
            if (alreadyCalled) {
                AssertionError e = new AssertionError((Object)"completeRequest called more than once");
                log.log(Level.WARNING, "Assertion failed.", (Throwable)((Object)e));
                throw e;
            }
            boolean reportedError = false;
            if (error != null) {
                if (HttpRequestDispatch.isErrorOfType(error, EofException.class, IOException.class)) {
                    log.log(Level.FINE, (Throwable)error, () -> "Network connection was unexpectedly terminated: " + parent.jettyRequest.getRequestURI());
                    parent.metricReporter.prematurelyClosed();
                } else if (!HttpRequestDispatch.isErrorOfType(error, OverloadException.class, BindingNotFoundException.class, RequestException.class)) {
                    log.log(Level.WARNING, "Request failed: " + parent.jettyRequest.getRequestURI(), (Throwable)error);
                }
                reportedError = true;
                parent.metricReporter.failedResponse();
            } else {
                parent.metricReporter.successfulResponse();
            }
            try {
                parent.async.complete();
                log.finest(() -> "Request completed successfully: " + parent.jettyRequest.getRequestURI());
            }
            catch (Throwable throwable) {
                Level level = reportedError ? Level.FINE : Level.WARNING;
                log.log(level, "Async.complete failed", throwable);
            }
        };
        this.jDiscContext = jDiscContext;
        this.requestHandler = HttpRequestDispatch.newRequestHandler(jDiscContext, accessLogEntry, servletRequest);
        this.jettyRequest = (org.eclipse.jetty.server.Request)servletRequest;
        this.metricReporter = new RequestMetricReporter(jDiscContext.metric, metricContext, this.jettyRequest.getTimeStamp());
        this.servletResponseController = new ServletResponseController(servletRequest, servletResponse, jDiscContext.janitor, this.metricReporter, jDiscContext.developerMode());
        HttpRequestDispatch.markConnectionAsNonPersistentIfThresholdReached(servletRequest);
        this.async = servletRequest.startAsync();
        this.async.setTimeout(0L);
        this.metricReporter.uriLength(this.jettyRequest.getOriginalURI().length());
    }

    public void dispatch() throws IOException {
        ServletRequestReader servletRequestReader;
        try {
            servletRequestReader = this.handleRequest();
        }
        catch (Throwable throwable) {
            this.servletResponseController.trySendError(throwable);
            this.servletResponseController.finishedFuture().whenComplete((result, exception) -> this.completeRequestCallback.accept(null, throwable));
            return;
        }
        try {
            HttpRequestDispatch.onError(servletRequestReader.finishedFuture, this.servletResponseController::trySendError);
            HttpRequestDispatch.onError(this.servletResponseController.finishedFuture(), servletRequestReader::onError);
            CompletableFuture.allOf(servletRequestReader.finishedFuture, this.servletResponseController.finishedFuture()).whenComplete((BiConsumer)this.completeRequestCallback);
        }
        catch (Throwable throwable) {
            log.log(Level.WARNING, "Failed registering finished listeners.", throwable);
        }
    }

    private static void markConnectionAsNonPersistentIfThresholdReached(HttpServletRequest request) {
        double maxConnectionLifeInSeconds;
        HttpConnection connection;
        ConnectorConfig connectorConfig = JDiscHttpServlet.getConnector(request).connectorConfig();
        int maxRequestsPerConnection = connectorConfig.maxRequestsPerConnection();
        if (maxRequestsPerConnection > 0 && (connection = HttpServletRequestUtils.getConnection(request)).getMessagesIn() >= (long)maxRequestsPerConnection) {
            connection.getGenerator().setPersistent(false);
        }
        if ((maxConnectionLifeInSeconds = connectorConfig.maxConnectionLife()) > 0.0) {
            HttpConnection connection2 = HttpServletRequestUtils.getConnection(request);
            Instant expireAt = Instant.ofEpochMilli((long)((double)connection2.getCreatedTimeStamp() + maxConnectionLifeInSeconds * 1000.0));
            if (Instant.now().isAfter(expireAt)) {
                connection2.getGenerator().setPersistent(false);
            }
        }
    }

    @SafeVarargs
    private static boolean isErrorOfType(Throwable throwable, Class<? extends Throwable> ... handledTypes) {
        return Arrays.stream(handledTypes).anyMatch(exceptionType -> exceptionType.isInstance(throwable) || throwable instanceof CompletionException && exceptionType.isInstance(throwable.getCause()));
    }

    private ServletRequestReader handleRequest() throws IOException {
        ContentChannel requestContentChannel;
        HttpRequest jdiscRequest = HttpRequestFactory.newJDiscRequest(this.jDiscContext.container, (HttpServletRequest)this.jettyRequest);
        try (ResourceReference ref = References.fromResource((SharedResource)jdiscRequest);){
            HttpRequestFactory.copyHeaders((HttpServletRequest)this.jettyRequest, jdiscRequest);
            requestContentChannel = this.requestHandler.handleRequest((Request)jdiscRequest, this.servletResponseController.responseHandler);
        }
        ServletInputStream servletInputStream = this.jettyRequest.getInputStream();
        ServletRequestReader servletRequestReader = new ServletRequestReader(servletInputStream, requestContentChannel, this.jDiscContext.janitor, this.metricReporter);
        servletInputStream.setReadListener((ReadListener)servletRequestReader);
        return servletRequestReader;
    }

    private static void onError(CompletableFuture<?> future, Consumer<Throwable> errorHandler) {
        future.whenComplete((result, exception) -> {
            if (exception != null) {
                errorHandler.accept((Throwable)exception);
            }
        });
    }

    ContentChannel handleRequestFilterResponse(Response response) {
        try {
            this.jettyRequest.getInputStream().close();
            ContentChannel responseContentChannel = this.servletResponseController.responseHandler.handleResponse(response);
            this.servletResponseController.finishedFuture().whenComplete((BiConsumer)this.completeRequestCallback);
            return responseContentChannel;
        }
        catch (IOException e) {
            throw Exceptions.throwUnchecked((Throwable)e);
        }
    }

    private static RequestHandler newRequestHandler(JDiscContext context, AccessLogEntry accessLogEntry, HttpServletRequest servletRequest) {
        RequestHandler requestHandler = HttpRequestDispatch.wrapHandlerIfFormPost((RequestHandler)new FilteringRequestHandler(context.filterResolver, servletRequest), servletRequest, context.serverConfig.removeRawPostBodyForWwwUrlEncodedPost());
        return new AccessLoggingRequestHandler(requestHandler, accessLogEntry);
    }

    private static RequestHandler wrapHandlerIfFormPost(RequestHandler requestHandler, HttpServletRequest servletRequest, boolean removeBodyForFormPost) {
        if (!servletRequest.getMethod().equals("POST")) {
            return requestHandler;
        }
        String contentType = servletRequest.getHeader("Content-Type");
        if (contentType == null) {
            return requestHandler;
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded")) {
            return requestHandler;
        }
        return new FormPostRequestHandler(requestHandler, HttpRequestDispatch.getCharsetName(contentType), removeBodyForFormPost);
    }

    private static String getCharsetName(String contentType) {
        if (!contentType.startsWith(CHARSET_ANNOTATION, "application/x-www-form-urlencoded".length())) {
            return StandardCharsets.UTF_8.name();
        }
        return contentType.substring("application/x-www-form-urlencoded".length() + CHARSET_ANNOTATION.length());
    }
}

