/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.SslHandshakeFailedListener;
import com.yahoo.jdisc.http.ssl.SslContextFactoryProvider;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.List;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ConnectorFactory {
    private final ConnectorConfig connectorConfig;
    private final SslContextFactoryProvider sslContextFactoryProvider;

    @Inject
    public ConnectorFactory(ConnectorConfig connectorConfig, SslContextFactoryProvider sslContextFactoryProvider) {
        ConnectorFactory.runtimeConnectorConfigValidation(connectorConfig);
        this.connectorConfig = connectorConfig;
        this.sslContextFactoryProvider = sslContextFactoryProvider;
    }

    private static void runtimeConnectorConfigValidation(ConnectorConfig config) {
        ConnectorFactory.validateProxyProtocolConfiguration(config);
        ConnectorFactory.validateSecureRedirectConfig(config);
    }

    private static void validateProxyProtocolConfiguration(ConnectorConfig config) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = config.proxyProtocol();
        if (proxyProtocolConfig.enabled()) {
            boolean tlsMixedModeEnabled;
            boolean bl = tlsMixedModeEnabled = TransportSecurityUtils.getInsecureMixedMode() != MixedMode.DISABLED;
            if (!ConnectorFactory.isSslEffectivelyEnabled(config) || tlsMixedModeEnabled) {
                throw new IllegalArgumentException("Proxy protocol can only be enabled if connector is effectively HTTPS only");
            }
        }
    }

    private static void validateSecureRedirectConfig(ConnectorConfig config) {
        if (config.secureRedirect().enabled() && ConnectorFactory.isSslEffectivelyEnabled(config)) {
            throw new IllegalArgumentException("Secure redirect can only be enabled on connectors without HTTPS");
        }
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public ServerConnector createConnector(Metric metric, Server server, JettyConnectionLogger connectionLogger) {
        JDiscServerConnector connector = new JDiscServerConnector(this.connectorConfig, metric, server, connectionLogger, (ConnectionFactory[])this.createConnectionFactories(metric).toArray(ConnectionFactory[]::new));
        connector.setPort(this.connectorConfig.listenPort());
        connector.setName(this.connectorConfig.name());
        connector.setAcceptQueueSize(this.connectorConfig.acceptQueueSize());
        connector.setReuseAddress(this.connectorConfig.reuseAddress());
        connector.setIdleTimeout((long)(this.connectorConfig.idleTimeout() * 1000.0));
        return connector;
    }

    private List<ConnectionFactory> createConnectionFactories(Metric metric) {
        HttpConnectionFactory httpFactory = this.newHttpConnectionFactory();
        if (!ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            return List.of(httpFactory);
        }
        if (this.connectorConfig.ssl().enabled()) {
            return this.connectionFactoriesForHttps(metric, httpFactory);
        }
        if (TransportSecurityUtils.isTransportSecurityEnabled()) {
            switch (TransportSecurityUtils.getInsecureMixedMode()) {
                case TLS_CLIENT_MIXED_SERVER: 
                case PLAINTEXT_CLIENT_MIXED_SERVER: {
                    return List.of(new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{this.newSslConnectionFactory(metric, httpFactory)}), httpFactory);
                }
                case DISABLED: {
                    return this.connectionFactoriesForHttps(metric, httpFactory);
                }
            }
            throw new IllegalStateException();
        }
        return List.of(httpFactory);
    }

    private List<ConnectionFactory> connectionFactoriesForHttps(Metric metric, HttpConnectionFactory httpFactory) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = this.connectorConfig.proxyProtocol();
        SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, httpFactory);
        if (proxyProtocolConfig.enabled()) {
            if (proxyProtocolConfig.mixedMode()) {
                return List.of(new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory, new ProxyConnectionFactory(sslFactory.getProtocol())}), sslFactory, httpFactory);
            }
            return List.of(new ProxyConnectionFactory(sslFactory.getProtocol()), sslFactory, httpFactory);
        }
        return List.of(sslFactory, httpFactory);
    }

    private HttpConnectionFactory newHttpConnectionFactory() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setHeaderCacheSize(this.connectorConfig.headerCacheSize());
        httpConfig.setOutputBufferSize(this.connectorConfig.outputBufferSize());
        httpConfig.setRequestHeaderSize(this.connectorConfig.requestHeaderSize());
        httpConfig.setResponseHeaderSize(this.connectorConfig.responseHeaderSize());
        if (ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        }
        return new HttpConnectionFactory(httpConfig);
    }

    private SslConnectionFactory newSslConnectionFactory(Metric metric, HttpConnectionFactory httpFactory) {
        SslContextFactory ctxFactory = this.sslContextFactoryProvider.getInstance(this.connectorConfig.name(), this.connectorConfig.listenPort());
        SslConnectionFactory connectionFactory = new SslConnectionFactory(ctxFactory, httpFactory.getProtocol());
        connectionFactory.addBean((Object)new SslHandshakeFailedListener(metric, this.connectorConfig.name(), this.connectorConfig.listenPort()));
        return connectionFactory;
    }

    private static boolean isSslEffectivelyEnabled(ConnectorConfig config) {
        return config.ssl().enabled() || config.implicitTlsEnabled() && TransportSecurityUtils.isTransportSecurityEnabled();
    }
}

