/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.compress.ZstdOuputStream;
import com.yahoo.container.logging.LogFormatter;
import com.yahoo.container.logging.LogWriter;
import com.yahoo.io.NativeIO;
import com.yahoo.log.LogFileDb;
import com.yahoo.protect.Process;
import com.yahoo.yolean.Exceptions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

class LogFileHandler<LOGTYPE> {
    private static final Logger logger = Logger.getLogger(LogFileHandler.class.getName());
    private final BlockingQueue<Operation<LOGTYPE>> logQueue;
    final LogThread<LOGTYPE> logThread;

    LogFileHandler(Compression compression, String filePattern, String rotationTimes, String symlinkName, int queueSize, String threadName, LogWriter<LOGTYPE> logWriter) {
        this(compression, filePattern, LogFileHandler.calcTimesMinutes(rotationTimes), symlinkName, queueSize, threadName, logWriter);
    }

    LogFileHandler(Compression compression, String filePattern, long[] rotationTimes, String symlinkName, int queueSize, String threadName, LogWriter<LOGTYPE> logWriter) {
        this.logQueue = new LinkedBlockingQueue<Operation<LOGTYPE>>(queueSize);
        this.logThread = new LogThread<LOGTYPE>(logWriter, filePattern, compression, rotationTimes, symlinkName, threadName, this::poll);
        this.logThread.start();
    }

    private Operation<LOGTYPE> poll() throws InterruptedException {
        return this.logQueue.poll(100L, TimeUnit.MILLISECONDS);
    }

    public void publish(LOGTYPE r) {
        this.addOperation(new Operation<LOGTYPE>(r));
    }

    void publishAndWait(LOGTYPE r) {
        this.addOperationAndWait(new Operation<LOGTYPE>(r));
    }

    public void flush() {
        this.addOperationAndWait(new Operation(Operation.Type.flush));
    }

    void rotateNow() {
        this.addOperationAndWait(new Operation(Operation.Type.rotate));
    }

    public void close() {
        this.addOperationAndWait(new Operation(Operation.Type.close));
    }

    private void addOperation(Operation<LOGTYPE> op) {
        try {
            this.logQueue.put(op);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addOperationAndWait(Operation<LOGTYPE> op) {
        try {
            this.logQueue.put(op);
            op.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void shutdown() {
        this.logThread.interrupt();
        try {
            this.logThread.executor.shutdownNow();
            this.logThread.executor.awaitTermination(600L, TimeUnit.SECONDS);
            this.logThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static long[] calcTimesMinutes(String times) {
        long interval;
        long lasttime;
        long endOfDay;
        long moreneeded;
        ArrayList<Long> list = new ArrayList<Long>(50);
        int i = 0;
        boolean etc = false;
        while (i < times.length()) {
            if (times.charAt(i) == ' ') {
                ++i;
                continue;
            }
            int j = i;
            if ((i = times.indexOf(32, i)) == -1) {
                i = times.length();
            }
            if (times.charAt(j) == '.' && times.substring(j, i).equals("...")) {
                etc = true;
                break;
            }
            list.add(Long.valueOf(times.substring(j, i)));
        }
        int size = list.size();
        long[] longtimes = new long[size];
        for (i = 0; i < size; ++i) {
            longtimes[i] = (Long)list.get(i) * 60000L;
        }
        if (etc && (moreneeded = ((endOfDay = 86400000L) - (lasttime = longtimes[size - 1])) / (interval = lasttime - longtimes[size - 2])) > 0L) {
            int newsize = size + (int)moreneeded;
            long[] temp = new long[newsize];
            for (i = 0; i < size; ++i) {
                temp[i] = longtimes[i];
            }
            while (size < newsize) {
                temp[size++] = lasttime += interval;
            }
            longtimes = temp;
        }
        return longtimes;
    }

    String getFileName() {
        return this.logThread.fileName;
    }

    private static class AtomicFileOutputStream
    extends FileOutputStream {
        private final Path path;
        private final Path tmpPath;
        private volatile boolean closed = false;

        private AtomicFileOutputStream(Path path, Path tmpPath) throws FileNotFoundException {
            super(tmpPath.toFile());
            this.path = path;
            this.tmpPath = tmpPath;
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
            if (!this.closed) {
                Files.move(this.tmpPath, this.path, StandardCopyOption.ATOMIC_MOVE);
                this.closed = true;
            }
        }

        private static AtomicFileOutputStream create(Path path) throws FileNotFoundException {
            return new AtomicFileOutputStream(path, path.resolveSibling("." + path.getFileName() + ".tmp"));
        }
    }

    private static class PageCacheFriendlyFileOutputStream
    extends OutputStream {
        private final NativeIO nativeIO;
        private final FileOutputStream fileOut;
        private final BufferedOutputStream bufferedOut;
        private final int bufferSize;
        private long lastDropPosition = 0L;

        PageCacheFriendlyFileOutputStream(NativeIO nativeIO, Path file, int bufferSize) throws FileNotFoundException {
            this.nativeIO = nativeIO;
            this.fileOut = new FileOutputStream(file.toFile(), true);
            this.bufferedOut = new BufferedOutputStream(this.fileOut, bufferSize);
            this.bufferSize = bufferSize;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.bufferedOut.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.bufferedOut.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.bufferedOut.write(b);
        }

        @Override
        public void close() throws IOException {
            this.bufferedOut.close();
        }

        @Override
        public void flush() throws IOException {
            this.bufferedOut.flush();
            long newPos = this.fileOut.getChannel().position();
            if (newPos >= this.lastDropPosition + (long)this.bufferSize) {
                this.nativeIO.dropPartialFileFromCache(this.fileOut.getFD(), this.lastDropPosition, newPos, true);
                this.lastDropPosition = newPos;
            }
        }
    }

    private static class Operation<LOGTYPE> {
        final Type type;
        final Optional<LOGTYPE> log;
        final CountDownLatch countDownLatch = new CountDownLatch(1);

        Operation(Type type) {
            this(type, Optional.empty());
        }

        Operation(LOGTYPE log) {
            this(Type.log, Optional.of(log));
        }

        private Operation(Type type, Optional<LOGTYPE> log) {
            this.type = type;
            this.log = log;
        }

        static enum Type {
            log,
            flush,
            close,
            rotate;

        }
    }

    static class LogThread<LOGTYPE>
    extends Thread {
        private final Pollable<LOGTYPE> operationProvider;
        long lastFlush = 0L;
        private PageCacheFriendlyFileOutputStream fileOutput = null;
        private long nextRotationTime = 0L;
        private final String filePattern;
        private volatile String fileName;
        private final LogWriter<LOGTYPE> logWriter;
        private final Compression compression;
        private final long[] rotationTimes;
        private final String symlinkName;
        private final ExecutorService executor = LogThread.createCompressionTaskExecutor();
        private final NativeIO nativeIO = new NativeIO();
        private static final long lengthOfDayMillis = 86400000L;

        LogThread(LogWriter<LOGTYPE> logWriter, String filePattern, Compression compression, long[] rotationTimes, String symlinkName, String threadName, Pollable<LOGTYPE> operationProvider) {
            super(threadName);
            this.setDaemon(true);
            this.logWriter = logWriter;
            this.filePattern = filePattern;
            this.compression = compression;
            this.rotationTimes = rotationTimes;
            this.symlinkName = symlinkName != null && !symlinkName.isBlank() ? symlinkName : null;
            this.operationProvider = operationProvider;
        }

        private static ExecutorService createCompressionTaskExecutor() {
            return Executors.newSingleThreadExecutor(runnable -> {
                Thread thread = new Thread(runnable, "logfilehandler.compression");
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            });
        }

        @Override
        public void run() {
            try {
                this.handleLogOperations();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                Process.logAndDie((String)"Failed storing log records", (Throwable)e);
            }
            this.internalFlush();
        }

        private void handleLogOperations() throws InterruptedException {
            while (!this.isInterrupted()) {
                Operation<LOGTYPE> r = this.operationProvider.poll();
                if (r != null) {
                    if (r.type == Operation.Type.flush) {
                        this.internalFlush();
                    } else if (r.type == Operation.Type.close) {
                        this.internalClose();
                    } else if (r.type == Operation.Type.rotate) {
                        this.internalRotateNow();
                        this.lastFlush = System.nanoTime();
                    } else if (r.type == Operation.Type.log) {
                        this.internalPublish(r.log.get());
                        this.flushIfOld(3L, TimeUnit.SECONDS);
                    }
                    r.countDownLatch.countDown();
                    continue;
                }
                this.flushIfOld(100L, TimeUnit.MILLISECONDS);
            }
        }

        private void flushIfOld(long age, TimeUnit unit) {
            long now = System.nanoTime();
            if (TimeUnit.NANOSECONDS.toMillis(now - this.lastFlush) > unit.toMillis(age)) {
                this.internalFlush();
                this.lastFlush = now;
            }
        }

        private void internalFlush() {
            try {
                if (this.fileOutput != null) {
                    this.fileOutput.flush();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to flush file output: " + Exceptions.toMessageString((Throwable)e), e);
            }
        }

        private void internalClose() {
            try {
                if (this.fileOutput != null) {
                    this.fileOutput.flush();
                    this.fileOutput.close();
                    this.fileOutput = null;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Got error while closing log file: " + e.getMessage(), e);
            }
        }

        private void internalPublish(LOGTYPE r) {
            long now = System.currentTimeMillis();
            if (this.nextRotationTime <= 0L) {
                this.nextRotationTime = this.getNextRotationTime(now);
            }
            if (now > this.nextRotationTime || this.fileOutput == null) {
                this.internalRotateNow();
            }
            try {
                this.logWriter.write(r, this.fileOutput);
                this.fileOutput.write(10);
            }
            catch (IOException e) {
                logger.warning("Failed writing log record: " + Exceptions.toMessageString((Throwable)e));
            }
        }

        long getNextRotationTime(long now) {
            if (now <= 0L) {
                now = System.currentTimeMillis();
            }
            long nowTod = LogThread.timeOfDayMillis(now);
            long next = 0L;
            for (long rotationTime : this.rotationTimes) {
                if (nowTod >= rotationTime) continue;
                next = rotationTime - nowTod + now;
                break;
            }
            if (next == 0L) {
                next = this.rotationTimes[0] + 86400000L - nowTod + now;
            }
            return next;
        }

        private void checkAndCreateDir(String pathname) {
            String pathExcludingFilename;
            File filepath;
            int lastSlash = pathname.lastIndexOf("/");
            if (lastSlash > -1 && !(filepath = new File(pathExcludingFilename = pathname.substring(0, lastSlash))).exists()) {
                filepath.mkdirs();
            }
        }

        private void internalRotateNow() {
            Path oldFile;
            String oldFileName = this.fileName;
            long now = System.currentTimeMillis();
            this.fileName = LogFormatter.insertDate(this.filePattern, now);
            this.internalClose();
            try {
                this.checkAndCreateDir(this.fileName);
                this.fileOutput = new PageCacheFriendlyFileOutputStream(this.nativeIO, Paths.get(this.fileName, new String[0]), 0x400000);
                LogFileDb.nowLoggingTo((String)this.fileName);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't open log file '" + this.fileName + "'", e);
            }
            if (oldFileName == null) {
                oldFileName = this.getOldFileNameFromSymlink();
            }
            this.createSymlinkToCurrentFile();
            this.nextRotationTime = 0L;
            if (oldFileName != null && Files.exists(oldFile = Paths.get(oldFileName, new String[0]), new LinkOption[0])) {
                this.executor.execute(() -> LogThread.runCompression(this.nativeIO, oldFile, this.compression));
            }
        }

        private static void runCompression(NativeIO nativeIO, Path oldFile, Compression compression) {
            switch (compression) {
                case ZSTD: {
                    LogThread.runCompressionZstd(nativeIO, oldFile);
                    break;
                }
                case GZIP: {
                    LogThread.runCompressionGzip(nativeIO, oldFile);
                    break;
                }
                case NONE: {
                    LogThread.runCompressionNone(nativeIO, oldFile);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown compression " + compression);
                }
            }
        }

        private static void runCompressionNone(NativeIO nativeIO, Path oldFile) {
            nativeIO.dropFileFromCache(oldFile.toFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runCompressionZstd(NativeIO nativeIO, Path oldFile) {
            try {
                Path compressedFile = Paths.get(oldFile.toString() + ".zst", new String[0]);
                int bufferSize = 0x200000;
                try (AtomicFileOutputStream fileOut = AtomicFileOutputStream.create(compressedFile);
                     ZstdOuputStream out = new ZstdOuputStream((OutputStream)fileOut, bufferSize);
                     FileInputStream in = new FileInputStream(oldFile.toFile());){
                    LogThread.pageFriendlyTransfer(nativeIO, (OutputStream)out, fileOut.getFD(), in, bufferSize);
                    out.flush();
                }
                Files.delete(oldFile);
                nativeIO.dropFileFromCache(compressedFile.toFile());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to compress log file with zstd: " + oldFile, e);
            }
            finally {
                nativeIO.dropFileFromCache(oldFile.toFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runCompressionGzip(NativeIO nativeIO, Path oldFile) {
            try {
                Path gzippedFile = Paths.get(oldFile.toString() + ".gz", new String[0]);
                try (AtomicFileOutputStream fileOut = AtomicFileOutputStream.create(gzippedFile);
                     GZIPOutputStream compressor = new GZIPOutputStream((OutputStream)fileOut, 0x100000);
                     FileInputStream inputStream = new FileInputStream(oldFile.toFile());){
                    LogThread.pageFriendlyTransfer(nativeIO, compressor, fileOut.getFD(), inputStream, 0x400000);
                    compressor.finish();
                    compressor.flush();
                }
                Files.delete(oldFile);
                nativeIO.dropFileFromCache(gzippedFile.toFile());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to compress log file with gzip: " + oldFile, e);
            }
            finally {
                nativeIO.dropFileFromCache(oldFile.toFile());
            }
        }

        private static void pageFriendlyTransfer(NativeIO nativeIO, OutputStream out, FileDescriptor outDescriptor, FileInputStream in, int bufferSize) throws IOException {
            int read;
            long totalBytesRead = 0L;
            byte[] buffer = new byte[bufferSize];
            while ((read = in.read(buffer)) >= 0) {
                out.write(buffer, 0, read);
                if (read > 0) {
                    nativeIO.dropPartialFileFromCache(in.getFD(), totalBytesRead, (long)read, false);
                    nativeIO.dropPartialFileFromCache(outDescriptor, totalBytesRead, (long)read, false);
                }
                totalBytesRead += (long)read;
            }
        }

        private void createSymlinkToCurrentFile() {
            if (this.symlinkName == null) {
                return;
            }
            Path target = Paths.get(this.fileName, new String[0]);
            Path link = target.resolveSibling(this.symlinkName);
            try {
                Files.deleteIfExists(link);
                Files.createSymbolicLink(link, target.getFileName(), new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to create symbolic link to current log file: " + e.getMessage(), e);
            }
        }

        private String getOldFileNameFromSymlink() {
            if (this.symlinkName == null) {
                return null;
            }
            try {
                return Paths.get(this.fileName, new String[0]).resolveSibling(this.symlinkName).toRealPath(new LinkOption[0]).toString();
            }
            catch (IOException e) {
                return null;
            }
        }

        private static long timeOfDayMillis(long time) {
            return time % 86400000L;
        }
    }

    @FunctionalInterface
    private static interface Pollable<T> {
        public Operation<T> poll() throws InterruptedException;
    }

    static enum Compression {
        NONE,
        GZIP,
        ZSTD;

    }
}

