/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class AccessLogConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "740b06bed903b94f5b58b9c54a007f7f";
    public static final String CONFIG_DEF_NAME = "access-log";
    public static final String CONFIG_DEF_NAMESPACE = "container.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.core", "fileHandler.pattern string", "fileHandler.rotation string default=\"0 60 ...\"", "fileHandler.symlink string default=\"\"", "fileHandler.compressOnRotation bool default=true", "fileHandler.compressionFormat enum {GZIP, ZSTD} default=GZIP", "fileHandler.queueSize int default=10000"};
    private final FileHandler fileHandler;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public AccessLogConfig(Builder builder) {
        this(builder, true);
    }

    private AccessLogConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for access-log must be initialized: " + builder.__uninitialized);
        }
        this.fileHandler = new FileHandler(builder.fileHandler, throwIfUninitialized);
    }

    public FileHandler fileHandler() {
        return this.fileHandler;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AccessLogConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class FileHandler
    extends InnerNode {
        private final StringNode pattern;
        private final StringNode rotation;
        private final StringNode symlink;
        private final BooleanNode compressOnRotation;
        private final CompressionFormat compressionFormat;
        private final IntegerNode queueSize;

        public FileHandler(Builder builder) {
            this(builder, true);
        }

        private FileHandler(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for access-log.fileHandler must be initialized: " + builder.__uninitialized);
            }
            this.pattern = builder.pattern == null ? new StringNode() : new StringNode(builder.pattern);
            this.rotation = builder.rotation == null ? new StringNode("0 60 ...") : new StringNode(builder.rotation);
            this.symlink = builder.symlink == null ? new StringNode(AccessLogConfig.CONFIG_DEF_VERSION) : new StringNode(builder.symlink);
            this.compressOnRotation = builder.compressOnRotation == null ? new BooleanNode(true) : new BooleanNode(builder.compressOnRotation.booleanValue());
            this.compressionFormat = builder.compressionFormat == null ? new CompressionFormat(CompressionFormat.GZIP) : new CompressionFormat(builder.compressionFormat);
            this.queueSize = builder.queueSize == null ? new IntegerNode(10000) : new IntegerNode(builder.queueSize.intValue());
        }

        public String pattern() {
            return this.pattern.value();
        }

        public String rotation() {
            return this.rotation.value();
        }

        public String symlink() {
            return this.symlink.value();
        }

        public boolean compressOnRotation() {
            return this.compressOnRotation.value();
        }

        public CompressionFormat.Enum compressionFormat() {
            return (CompressionFormat.Enum)((Object)this.compressionFormat.value());
        }

        public int queueSize() {
            return this.queueSize.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(FileHandler newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("fileHandler");
            return changes;
        }

        public static final class CompressionFormat
        extends EnumNode<Enum> {
            public static final Enum GZIP = Enum.GZIP;
            public static final Enum ZSTD = Enum.ZSTD;

            public CompressionFormat() {
                this.value = null;
            }

            public CompressionFormat(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                GZIP,
                ZSTD;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("pattern"));
            private String pattern = null;
            private String rotation = null;
            private String symlink = null;
            private Boolean compressOnRotation = null;
            private CompressionFormat.Enum compressionFormat = null;
            private Integer queueSize = null;

            public Builder() {
            }

            public Builder(FileHandler config) {
                this.pattern(config.pattern());
                this.rotation(config.rotation());
                this.symlink(config.symlink());
                this.compressOnRotation(config.compressOnRotation());
                this.compressionFormat(config.compressionFormat());
                this.queueSize(config.queueSize());
            }

            private Builder override(Builder __superior) {
                if (__superior.pattern != null) {
                    this.pattern(__superior.pattern);
                }
                if (__superior.rotation != null) {
                    this.rotation(__superior.rotation);
                }
                if (__superior.symlink != null) {
                    this.symlink(__superior.symlink);
                }
                if (__superior.compressOnRotation != null) {
                    this.compressOnRotation(__superior.compressOnRotation);
                }
                if (__superior.compressionFormat != null) {
                    this.compressionFormat(__superior.compressionFormat);
                }
                if (__superior.queueSize != null) {
                    this.queueSize(__superior.queueSize);
                }
                return this;
            }

            public Builder pattern(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.pattern = __value;
                this.__uninitialized.remove("pattern");
                return this;
            }

            public Builder rotation(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.rotation = __value;
                return this;
            }

            public Builder symlink(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.symlink = __value;
                return this;
            }

            public Builder compressOnRotation(boolean __value) {
                this.compressOnRotation = __value;
                return this;
            }

            private Builder compressOnRotation(String __value) {
                return this.compressOnRotation(Boolean.valueOf(__value));
            }

            public Builder compressionFormat(CompressionFormat.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.compressionFormat = __value;
                return this;
            }

            private Builder compressionFormat(String __value) {
                return this.compressionFormat(CompressionFormat.Enum.valueOf(__value));
            }

            public Builder queueSize(int __value) {
                this.queueSize = __value;
                return this;
            }

            private Builder queueSize(String __value) {
                return this.queueSize(Integer.valueOf(__value));
            }

            public FileHandler build() {
                return new FileHandler(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public FileHandler.Builder fileHandler = new FileHandler.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(AccessLogConfig config) {
            this.fileHandler(new FileHandler.Builder(config.fileHandler()));
        }

        private Builder override(Builder __superior) {
            this.fileHandler(this.fileHandler.override(__superior.fileHandler));
            return this;
        }

        public Builder fileHandler(FileHandler.Builder __builder) {
            this.fileHandler = __builder;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AccessLogConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AccessLogConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AccessLogConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public AccessLogConfig build() {
            return new AccessLogConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

