/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.HttpConnection;

public class HttpServletRequestUtils {
    private HttpServletRequestUtils() {
    }

    public static HttpConnection getConnection(HttpServletRequest request) {
        return (HttpConnection)request.getAttribute("org.eclipse.jetty.server.HttpConnection");
    }

    public static int getConnectorLocalPort(HttpServletRequest request) {
        JDiscServerConnector connector = (JDiscServerConnector)HttpServletRequestUtils.getConnection(request).getConnector();
        int actualLocalPort = connector.getLocalPort();
        int localPortIfConnectorUnopened = -1;
        int localPortIfConnectorClosed = -2;
        if (actualLocalPort == localPortIfConnectorUnopened || actualLocalPort == localPortIfConnectorClosed) {
            int localPortEphemeralPort;
            int configuredLocalPort = connector.listenPort();
            if (configuredLocalPort == (localPortEphemeralPort = 0)) {
                throw new IllegalStateException("Unable to determine connector's listen port");
            }
            return configuredLocalPort;
        }
        return actualLocalPort;
    }
}

