/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.RequestLog;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.jdisc.http.server.jetty.AccessLogRequestLog;
import com.yahoo.jdisc.http.server.jetty.ConnectorFactory;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.FilterInvoker;
import com.yahoo.jdisc.http.server.jetty.HealthCheckProxyHandler;
import com.yahoo.jdisc.http.server.jetty.HttpResponseStatisticsCollector;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscFilterInvokerFilter;
import com.yahoo.jdisc.http.server.jetty.JDiscHttpServlet;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.SecuredRedirectHandler;
import com.yahoo.jdisc.http.server.jetty.ServerMetricReporter;
import com.yahoo.jdisc.http.server.jetty.TlsClientAuthenticationEnforcer;
import com.yahoo.jdisc.service.AbstractServerProvider;
import com.yahoo.jdisc.service.CurrentContainer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.remote.JMXServiceURL;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHttpOutputInterceptor;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyHttpServer
extends AbstractServerProvider {
    private static final Logger log = Logger.getLogger(JettyHttpServer.class.getName());
    private final ExecutorService janitor;
    private final Server server;
    private final List<Integer> listenedPorts = new ArrayList<Integer>();
    private final ServerMetricReporter metricsReporter;

    @Inject
    public JettyHttpServer(CurrentContainer container, Metric metric, ServerConfig serverConfig, ServletPathsConfig servletPathsConfig, FilterBindings filterBindings, ComponentRegistry<ConnectorFactory> connectorFactories, ComponentRegistry<ServletHolder> servletHolders, FilterInvoker filterInvoker, RequestLog requestLog, ConnectionLog connectionLog) {
        super(container);
        if (connectorFactories.allComponents().isEmpty()) {
            throw new IllegalArgumentException("No connectors configured.");
        }
        JettyHttpServer.initializeJettyLogging();
        this.server = new Server();
        this.server.setStopTimeout((long)(serverConfig.stopTimeout() * 1000.0));
        this.server.setRequestLog((org.eclipse.jetty.server.RequestLog)new AccessLogRequestLog(requestLog, serverConfig.accessLog()));
        JettyHttpServer.setupJmx(this.server, serverConfig);
        JettyHttpServer.configureJettyThreadpool(this.server, serverConfig);
        JettyConnectionLogger connectionLogger = new JettyConnectionLogger(serverConfig.connectionLog(), connectionLog);
        for (ConnectorFactory connectorFactory : connectorFactories.allComponents()) {
            ConnectorConfig connectorConfig = connectorFactory.getConnectorConfig();
            this.server.addConnector((Connector)connectorFactory.createConnector(metric, this.server, connectionLogger));
            this.listenedPorts.add(connectorConfig.listenPort());
        }
        this.janitor = JettyHttpServer.newJanitor();
        JDiscContext jDiscContext = new JDiscContext(filterBindings, container, this.janitor, metric, serverConfig);
        ServletHolder jdiscServlet = new ServletHolder((Servlet)new JDiscHttpServlet(jDiscContext));
        FilterHolder jDiscFilterInvokerFilter = new FilterHolder((Filter)new JDiscFilterInvokerFilter(jDiscContext, filterInvoker));
        List<JDiscServerConnector> connectors = Arrays.stream(this.server.getConnectors()).map(JDiscServerConnector.class::cast).collect(Collectors.toList());
        this.server.setHandler((Handler)this.getHandlerCollection(serverConfig, servletPathsConfig, connectors, jdiscServlet, servletHolders, jDiscFilterInvokerFilter));
        this.metricsReporter = new ServerMetricReporter(metric, this.server);
    }

    private static void initializeJettyLogging() {
        try {
            Log.setLog((org.eclipse.jetty.util.log.Logger)new JavaUtilLog());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize logging framework for Jetty");
        }
    }

    private static void setupJmx(Server server, ServerConfig serverConfig) {
        if (serverConfig.jmx().enabled()) {
            System.setProperty("java.rmi.server.hostname", "localhost");
            server.addBean((Object)new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
            server.addBean((Object)new ConnectorServer(JettyHttpServer.createJmxLoopbackOnlyServiceUrl(serverConfig.jmx().listenPort()), "org.eclipse.jetty.jmx:name=rmiconnectorserver"));
        }
    }

    private static void configureJettyThreadpool(Server server, ServerConfig config) {
        QueuedThreadPool pool = (QueuedThreadPool)server.getThreadPool();
        pool.setMaxThreads(config.maxWorkerThreads());
        pool.setMinThreads(config.minWorkerThreads());
    }

    private static JMXServiceURL createJmxLoopbackOnlyServiceUrl(int port) {
        try {
            return new JMXServiceURL("rmi", "localhost", port, "/jndi/rmi://localhost:" + port + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private HandlerCollection getHandlerCollection(ServerConfig serverConfig, ServletPathsConfig servletPathsConfig, List<JDiscServerConnector> connectors, ServletHolder jdiscServlet, ComponentRegistry<ServletHolder> servletHolders, FilterHolder jDiscFilterInvokerFilter) {
        ServletContextHandler servletContextHandler = this.createServletContextHandler();
        servletHolders.allComponentsById().forEach((id, servlet) -> {
            String path = JettyHttpServer.getServletPath(servletPathsConfig, id);
            servletContextHandler.addServlet(servlet, path);
            servletContextHandler.addFilter(jDiscFilterInvokerFilter, path, EnumSet.allOf(DispatcherType.class));
        });
        servletContextHandler.addServlet(jdiscServlet, "/*");
        List<ConnectorConfig> connectorConfigs = connectors.stream().map(JDiscServerConnector::connectorConfig).collect(Collectors.toList());
        SecuredRedirectHandler secureRedirectHandler = new SecuredRedirectHandler(connectorConfigs);
        secureRedirectHandler.setHandler((Handler)servletContextHandler);
        HealthCheckProxyHandler proxyHandler = new HealthCheckProxyHandler(connectors);
        proxyHandler.setHandler((Handler)secureRedirectHandler);
        TlsClientAuthenticationEnforcer authEnforcer = new TlsClientAuthenticationEnforcer(connectorConfigs);
        authEnforcer.setHandler((Handler)proxyHandler);
        GzipHandler gzipHandler = this.newGzipHandler(serverConfig);
        gzipHandler.setHandler((Handler)authEnforcer);
        HttpResponseStatisticsCollector statisticsCollector = new HttpResponseStatisticsCollector(serverConfig.metric().monitoringHandlerPaths(), serverConfig.metric().searchHandlerPaths());
        statisticsCollector.setHandler((Handler)gzipHandler);
        StatisticsHandler statisticsHandler = this.newStatisticsHandler();
        statisticsHandler.setHandler((Handler)statisticsCollector);
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{statisticsHandler});
        return handlerCollection;
    }

    private static String getServletPath(ServletPathsConfig servletPathsConfig, ComponentId id) {
        return "/" + servletPathsConfig.servlets(id.stringValue()).path();
    }

    private ServletContextHandler createServletContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath("/");
        servletContextHandler.setDisplayName(JettyHttpServer.getDisplayName(this.listenedPorts));
        return servletContextHandler;
    }

    private static String getDisplayName(List<Integer> ports) {
        return ports.stream().map(Object::toString).collect(Collectors.joining(":"));
    }

    private static ExecutorService newJanitor() {
        int threadPoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 8);
        log.info("Creating janitor executor with " + threadPoolSize + " threads");
        return Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)new DaemonThreadFactory(JettyHttpServer.class.getName() + "-Janitor-"));
    }

    public void start() {
        try {
            this.server.start();
            this.metricsReporter.start();
            this.logEffectiveSslConfiguration();
        }
        catch (Exception e) {
            if (e instanceof IOException && e.getCause() instanceof BindException) {
                throw new RuntimeException("Failed to start server due to BindException. ListenPorts = " + this.listenedPorts.toString(), e.getCause());
            }
            throw new RuntimeException("Failed to start server.", e);
        }
    }

    private void logEffectiveSslConfiguration() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException();
        }
        for (Connector connector : this.server.getConnectors()) {
            ServerConnector serverConnector = (ServerConnector)connector;
            int localPort = serverConnector.getLocalPort();
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            if (sslConnectionFactory == null) continue;
            SslContextFactory sslContextFactory = sslConnectionFactory.getSslContextFactory();
            log.info(String.format("Enabled SSL cipher suites for port '%d': %s", localPort, Arrays.toString(sslContextFactory.getSelectedCipherSuites())));
            log.info(String.format("Enabled SSL protocols for port '%d': %s", localPort, Arrays.toString(sslContextFactory.getSelectedProtocols())));
        }
    }

    public void close() {
        try {
            log.log(Level.INFO, String.format("Shutting down server (graceful=%b, timeout=%.1fs)", this.isGracefulShutdownEnabled(), (double)this.server.getStopTimeout() / 1000.0));
            this.server.stop();
            log.log(Level.INFO, "Server shutdown completed");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Server shutdown threw an unexpected exception.", e);
        }
        this.metricsReporter.shutdown();
        this.janitor.shutdown();
    }

    private boolean isGracefulShutdownEnabled() {
        return this.server.getChildHandlersByClass(StatisticsHandler.class).length > 0 && this.server.getStopTimeout() > 0L;
    }

    public int getListenPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    Server server() {
        return this.server;
    }

    private StatisticsHandler newStatisticsHandler() {
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.statsReset();
        return statisticsHandler;
    }

    private GzipHandler newGzipHandler(ServerConfig serverConfig) {
        GzipHandlerWithVaryHeaderFixed gzipHandler = new GzipHandlerWithVaryHeaderFixed();
        gzipHandler.setCompressionLevel(serverConfig.responseCompressionLevel());
        gzipHandler.setInflateBufferSize(8192);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "PATCH"});
        return gzipHandler;
    }

    private static class GzipHandlerWithVaryHeaderFixed
    extends GzipHandler {
        private GzipHandlerWithVaryHeaderFixed() {
        }

        public HttpField getVaryField() {
            return GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING;
        }
    }
}

