/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.server.jetty.FilterInvoker;
import com.yahoo.jdisc.http.server.jetty.FilterInvokingPrintWriter;
import com.yahoo.jdisc.http.server.jetty.FilterInvokingServletOutputStream;
import com.yahoo.jdisc.http.server.jetty.HttpRequestDispatch;
import com.yahoo.jdisc.http.server.jetty.HttpRequestFactory;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscHttpServlet;
import com.yahoo.jdisc.http.server.jetty.OneTimeRunnable;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class JDiscFilterInvokerFilter
implements Filter {
    private final JDiscContext jDiscContext;
    private final FilterInvoker filterInvoker;

    public JDiscFilterInvokerFilter(JDiscContext jDiscContext, FilterInvoker filterInvoker) {
        this.jDiscContext = jDiscContext;
        this.filterInvoker = filterInvoker;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        URI uri;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            uri = HttpRequestFactory.getUri(httpRequest);
        }
        catch (RequestException e) {
            httpResponse.sendError(e.getResponseStatus(), e.getMessage());
            return;
        }
        AtomicReference<Object> responseReturned = new AtomicReference<Object>(null);
        HttpServletRequest newRequest = this.runRequestFilterWithMatchingBinding(responseReturned, uri, httpRequest, httpResponse);
        assert (newRequest != null);
        responseReturned.compareAndSet(null, false);
        if (!((Boolean)responseReturned.get()).booleanValue()) {
            this.runChainAndResponseFilters(uri, newRequest, httpResponse, chain);
        }
    }

    private void runChainAndResponseFilters(URI uri, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<OneTimeRunnable> responseFilterInvoker = this.jDiscContext.filterResolver.resolveResponseFilter(request, uri).map(responseFilter -> new OneTimeRunnable(() -> this.filterInvoker.invokeResponseFilterChain((ResponseFilter)responseFilter, uri, request, response)));
        HttpServletResponse responseForServlet = responseFilterInvoker.map(invoker -> new FilterInvokingResponseWrapper(response, (OneTimeRunnable)invoker)).orElse(response);
        HttpServletRequest requestForServlet = responseFilterInvoker.map(invoker -> new FilterInvokingRequestWrapper(request, (OneTimeRunnable)invoker, responseForServlet)).orElse(request);
        chain.doFilter((ServletRequest)requestForServlet, (ServletResponse)responseForServlet);
        responseFilterInvoker.ifPresent(invoker -> {
            boolean requestHandledSynchronously;
            boolean bl = requestHandledSynchronously = !request.isAsyncStarted();
            if (requestHandledSynchronously) {
                invoker.runIfFirstInvocation();
            }
        });
    }

    private HttpServletRequest runRequestFilterWithMatchingBinding(AtomicReference<Boolean> responseReturned, URI uri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            RequestFilter requestFilter = this.jDiscContext.filterResolver.resolveRequestFilter(request, uri).orElse(null);
            if (requestFilter == null) {
                return request;
            }
            ResponseHandler responseHandler = this.createResponseHandler(responseReturned, request, response);
            return this.filterInvoker.invokeRequestFilterChain(requestFilter, uri, request, responseHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed running request filter chain for uri " + uri, e);
        }
    }

    private ResponseHandler createResponseHandler(AtomicReference<Boolean> responseReturned, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return jdiscResponse -> {
            boolean oldValueWasNull = responseReturned.compareAndSet(null, true);
            if (!oldValueWasNull) {
                throw new RuntimeException("Can't return response from filter asynchronously");
            }
            HttpRequestDispatch requestDispatch = this.createRequestDispatch(httpRequest, httpResponse);
            return requestDispatch.handleRequestFilterResponse(jdiscResponse);
        };
    }

    private HttpRequestDispatch createRequestDispatch(HttpServletRequest request, HttpServletResponse response) {
        try {
            AccessLogEntry accessLogEntry = null;
            return new HttpRequestDispatch(this.jDiscContext, accessLogEntry, JDiscHttpServlet.getConnector(request).createRequestMetricContext(request, Map.of()), request, response);
        }
        catch (IOException e) {
            throw Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public void destroy() {
    }

    private static class FilterInvokingResponseWrapper
    extends HttpServletResponseWrapper {
        private final OneTimeRunnable filterInvoker;

        public FilterInvokingResponseWrapper(HttpServletResponse response, OneTimeRunnable filterInvoker) {
            super(response);
            this.filterInvoker = filterInvoker;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            ServletOutputStream delegate = super.getOutputStream();
            return new FilterInvokingServletOutputStream(delegate, this.filterInvoker);
        }

        public PrintWriter getWriter() throws IOException {
            PrintWriter delegate = super.getWriter();
            return new FilterInvokingPrintWriter(delegate, this.filterInvoker);
        }
    }

    private static class FilterInvokingAsyncContext
    implements AsyncContext {
        private final AsyncContext delegate;
        private final OneTimeRunnable filterInvoker;
        private final ServletRequest servletRequest;
        private final ServletResponse servletResponse;

        public FilterInvokingAsyncContext(AsyncContext delegate, OneTimeRunnable filterInvoker, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.delegate = delegate;
            this.filterInvoker = filterInvoker;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }

        public ServletRequest getRequest() {
            return this.servletRequest;
        }

        public ServletResponse getResponse() {
            return this.servletResponse;
        }

        public boolean hasOriginalRequestAndResponse() {
            return this.delegate.hasOriginalRequestAndResponse();
        }

        public void dispatch() {
            this.delegate.dispatch();
        }

        public void dispatch(String s) {
            this.delegate.dispatch(s);
        }

        public void dispatch(ServletContext servletContext, String s) {
            this.delegate.dispatch(servletContext, s);
        }

        public void complete() {
            this.filterInvoker.runIfFirstInvocation();
            this.delegate.complete();
        }

        public void start(Runnable runnable) {
            this.delegate.start(runnable);
        }

        public void addListener(AsyncListener asyncListener) {
            this.delegate.addListener(asyncListener);
        }

        public void addListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.delegate.addListener(asyncListener, servletRequest, servletResponse);
        }

        public <T extends AsyncListener> T createListener(Class<T> aClass) throws ServletException {
            return (T)this.delegate.createListener(aClass);
        }

        public void setTimeout(long l) {
            this.delegate.setTimeout(l);
        }

        public long getTimeout() {
            return this.delegate.getTimeout();
        }
    }

    private static class FilterInvokingRequestWrapper
    extends HttpServletRequestWrapper {
        private final OneTimeRunnable filterInvoker;
        private final HttpServletResponse servletResponse;

        public FilterInvokingRequestWrapper(HttpServletRequest request, OneTimeRunnable filterInvoker, HttpServletResponse servletResponse) {
            super(request);
            this.filterInvoker = filterInvoker;
            this.servletResponse = servletResponse;
        }

        public AsyncContext startAsync() {
            AsyncContext asyncContext = super.startAsync();
            return new FilterInvokingAsyncContext(asyncContext, this.filterInvoker, (ServletRequest)this, (ServletResponse)this.servletResponse);
        }

        public AsyncContext startAsync(ServletRequest wrappedRequest, ServletResponse wrappedResponse) {
            AsyncContext asyncContext = super.startAsync(wrappedRequest, wrappedResponse);
            return new FilterInvokingAsyncContext(asyncContext, this.filterInvoker, (ServletRequest)this, wrappedResponse);
        }

        public AsyncContext getAsyncContext() {
            AsyncContext asyncContext = super.getAsyncContext();
            return new FilterInvokingAsyncContext(asyncContext, this.filterInvoker, (ServletRequest)this, (ServletResponse)this.servletResponse);
        }
    }
}

