/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.container.logging.HitCounts;
import com.yahoo.yolean.trace.TraceNode;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class RequestLogEntry {
    private final String connectionId;
    private final Instant timestamp;
    private final Duration duration;
    private final int localPort;
    private final String peerAddress;
    private final int peerPort;
    private final String remoteAddress;
    private final int remotePort;
    private final String userAgent;
    private final String referer;
    private final String httpMethod;
    private final String httpVersion;
    private final String hostString;
    private final int statusCode;
    private final long contentSize;
    private final String scheme;
    private final String rawPath;
    private final String rawQuery;
    private final Principal userPrincipal;
    private final Principal sslPrincipal;
    private final HitCounts hitCounts;
    private final TraceNode traceNode;
    private final Map<String, Collection<String>> extraAttributes;

    private RequestLogEntry(Builder builder) {
        this.connectionId = builder.connectionId;
        this.timestamp = builder.timestamp;
        this.duration = builder.duration;
        this.localPort = builder.localPort;
        this.peerAddress = builder.peerAddress;
        this.peerPort = builder.peerPort;
        this.remoteAddress = builder.remoteAddress;
        this.remotePort = builder.remotePort;
        this.userAgent = builder.userAgent;
        this.referer = builder.referer;
        this.httpMethod = builder.httpMethod;
        this.httpVersion = builder.httpVersion;
        this.hostString = builder.hostString;
        this.statusCode = builder.statusCode;
        this.contentSize = builder.contentSize;
        this.scheme = builder.scheme;
        this.rawPath = builder.rawPath;
        this.rawQuery = builder.rawQuery;
        this.userPrincipal = builder.userPrincipal;
        this.sslPrincipal = builder.sslPrincipal;
        this.hitCounts = builder.hitCounts;
        this.traceNode = builder.traceNode;
        this.extraAttributes = RequestLogEntry.copyExtraAttributes(builder.extraAttributes);
    }

    public Optional<String> connectionId() {
        return Optional.ofNullable(this.connectionId);
    }

    public Optional<Instant> timestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<Duration> duration() {
        return Optional.ofNullable(this.duration);
    }

    public OptionalInt localPort() {
        return RequestLogEntry.optionalInt(this.localPort);
    }

    public Optional<String> peerAddress() {
        return Optional.ofNullable(this.peerAddress);
    }

    public OptionalInt peerPort() {
        return RequestLogEntry.optionalInt(this.peerPort);
    }

    public Optional<String> remoteAddress() {
        return Optional.ofNullable(this.remoteAddress);
    }

    public OptionalInt remotePort() {
        return RequestLogEntry.optionalInt(this.remotePort);
    }

    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> referer() {
        return Optional.ofNullable(this.referer);
    }

    public Optional<String> httpMethod() {
        return Optional.ofNullable(this.httpMethod);
    }

    public Optional<String> httpVersion() {
        return Optional.ofNullable(this.httpVersion);
    }

    public Optional<String> hostString() {
        return Optional.ofNullable(this.hostString);
    }

    public OptionalInt statusCode() {
        return RequestLogEntry.optionalInt(this.statusCode);
    }

    public OptionalLong contentSize() {
        return RequestLogEntry.optionalLong(this.contentSize);
    }

    public Optional<String> scheme() {
        return Optional.ofNullable(this.scheme);
    }

    public Optional<String> rawPath() {
        return Optional.ofNullable(this.rawPath);
    }

    public Optional<String> rawQuery() {
        return Optional.ofNullable(this.rawQuery);
    }

    public Optional<Principal> userPrincipal() {
        return Optional.ofNullable(this.userPrincipal);
    }

    public Optional<Principal> sslPrincipal() {
        return Optional.ofNullable(this.sslPrincipal);
    }

    public Optional<HitCounts> hitCounts() {
        return Optional.ofNullable(this.hitCounts);
    }

    public Optional<TraceNode> traceNode() {
        return Optional.ofNullable(this.traceNode);
    }

    public Collection<String> extraAttributeKeys() {
        return Collections.unmodifiableCollection(this.extraAttributes.keySet());
    }

    public Collection<String> extraAttributeValues(String key) {
        return Collections.unmodifiableCollection(this.extraAttributes.get(key));
    }

    private static OptionalInt optionalInt(int value) {
        if (value == -1) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    private static OptionalLong optionalLong(long value) {
        if (value == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    private static Map<String, Collection<String>> copyExtraAttributes(Map<String, Collection<String>> extraAttributes) {
        HashMap<String, Collection<String>> copy = new HashMap<String, Collection<String>>();
        extraAttributes.forEach((key, value) -> copy.put((String)key, new ArrayList(value)));
        return copy;
    }

    public static class Builder {
        private String connectionId;
        private Instant timestamp;
        private Duration duration;
        private int localPort = -1;
        private String peerAddress;
        private int peerPort = -1;
        private String remoteAddress;
        private int remotePort = -1;
        private String userAgent;
        private String referer;
        private String httpMethod;
        private String httpVersion;
        private String hostString;
        private int statusCode = -1;
        private long contentSize = -1L;
        private String scheme;
        private String rawPath;
        private String rawQuery;
        private Principal userPrincipal;
        private HitCounts hitCounts;
        private TraceNode traceNode;
        private Principal sslPrincipal;
        private final Map<String, Collection<String>> extraAttributes = new HashMap<String, Collection<String>>();

        public Builder connectionId(String connectionId) {
            this.connectionId = Objects.requireNonNull(connectionId);
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp);
            return this;
        }

        public Builder duration(Duration duration) {
            this.duration = Objects.requireNonNull(duration);
            return this;
        }

        public Builder localPort(int localPort) {
            this.localPort = Builder.requireNonNegative(localPort);
            return this;
        }

        public Builder peerAddress(String peerAddress) {
            this.peerAddress = Objects.requireNonNull(peerAddress);
            return this;
        }

        public Builder peerPort(int peerPort) {
            this.peerPort = Builder.requireNonNegative(peerPort);
            return this;
        }

        public Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = Objects.requireNonNull(remoteAddress);
            return this;
        }

        public Builder remotePort(int remotePort) {
            this.remotePort = Builder.requireNonNegative(remotePort);
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent);
            return this;
        }

        public Builder referer(String referer) {
            this.referer = Objects.requireNonNull(referer);
            return this;
        }

        public Builder httpMethod(String httpMethod) {
            this.httpMethod = Objects.requireNonNull(httpMethod);
            return this;
        }

        public Builder httpVersion(String httpVersion) {
            this.httpVersion = Objects.requireNonNull(httpVersion);
            return this;
        }

        public Builder hostString(String hostString) {
            this.hostString = Objects.requireNonNull(hostString);
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = Builder.requireNonNegative(statusCode);
            return this;
        }

        public Builder contentSize(long contentSize) {
            this.contentSize = Builder.requireNonNegative(contentSize);
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = Objects.requireNonNull(scheme);
            return this;
        }

        public Builder rawPath(String rawPath) {
            this.rawPath = Objects.requireNonNull(rawPath);
            return this;
        }

        public Builder rawQuery(String rawQuery) {
            this.rawQuery = Objects.requireNonNull(rawQuery);
            return this;
        }

        public Builder userPrincipal(Principal userPrincipal) {
            this.userPrincipal = Objects.requireNonNull(userPrincipal);
            return this;
        }

        public Builder sslPrincipal(Principal sslPrincipal) {
            this.sslPrincipal = Objects.requireNonNull(sslPrincipal);
            return this;
        }

        public Builder hitCounts(HitCounts hitCounts) {
            this.hitCounts = Objects.requireNonNull(hitCounts);
            return this;
        }

        public Builder traceNode(TraceNode traceNode) {
            this.traceNode = Objects.requireNonNull(traceNode);
            return this;
        }

        public Builder addExtraAttribute(String key, String value) {
            this.extraAttributes.computeIfAbsent(Objects.requireNonNull(key), __ -> new ArrayList()).add(Objects.requireNonNull(value));
            return this;
        }

        public Builder addExtraAttributes(String key, Collection<String> values) {
            this.extraAttributes.computeIfAbsent(Objects.requireNonNull(key), __ -> new ArrayList()).addAll(Objects.requireNonNull(values));
            return this;
        }

        public RequestLogEntry build() {
            return new RequestLogEntry(this);
        }

        private static int requireNonNegative(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Value must be non-negative: " + value);
            }
            return value;
        }

        private static long requireNonNegative(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("Value must be non-negative: " + value);
            }
            return value;
        }
    }
}

