/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.model;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.component.chain.model.ComponentAdaptor;
import com.yahoo.component.chain.model.Resolver;
import com.yahoo.component.provider.ComponentRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ChainsModel {
    private final ComponentRegistry<ComponentAdaptor<ChainSpecification>> chainSpecifications = new ComponentRegistry();
    private final ComponentRegistry<ComponentAdaptor<ChainedComponentModel>> componentModels = new ComponentRegistry();

    public void register(ChainSpecification chainSpecification) {
        this.chainSpecifications.register(chainSpecification.componentId, ComponentAdaptor.create(chainSpecification.componentId, chainSpecification));
    }

    public void register(ComponentId globalComponentId, ChainedComponentModel componentModel) {
        assert (componentModel.getComponentId().withoutNamespace().equals((Object)globalComponentId.withoutNamespace()));
        this.componentModels.register(globalComponentId, ComponentAdaptor.create(globalComponentId, componentModel));
    }

    public Collection<ChainedComponentModel> allComponents() {
        ArrayList<ChainedComponentModel> components = new ArrayList<ChainedComponentModel>();
        for (ComponentAdaptor component : this.componentModels.allComponents()) {
            components.add((ChainedComponentModel)((Object)component.model));
        }
        return components;
    }

    public Collection<ChainSpecification> allChainsFlattened() {
        Resolver<ChainSpecification> resolver = new Resolver<ChainSpecification>(){

            @Override
            public ChainSpecification resolve(ComponentSpecification componentSpecification) {
                ComponentAdaptor spec = (ComponentAdaptor)((Object)ChainsModel.this.chainSpecifications.getComponent(componentSpecification));
                return spec == null ? null : (ChainSpecification)spec.model;
            }
        };
        ArrayList<ChainSpecification> chains = new ArrayList<ChainSpecification>();
        for (ComponentAdaptor chain : this.chainSpecifications.allComponents()) {
            chains.add(((ChainSpecification)chain.model).flatten(resolver));
        }
        return chains;
    }

    public void validate() {
        this.allChainsFlattened();
        for (ComponentAdaptor chain : this.chainSpecifications.allComponents()) {
            this.validate((ChainSpecification)chain.model);
        }
    }

    private void validate(ChainSpecification model) {
        for (ComponentSpecification componentSpec : model.componentReferences) {
            if (this.componentModels.getComponent(componentSpec) != null) continue;
            throw new RuntimeException("No component matching the component specification " + componentSpec);
        }
    }

    Map<ComponentId, ComponentAdaptor<ChainSpecification>> chainSpecifications() {
        return this.chainSpecifications.allComponentsById();
    }

    Map<ComponentId, ComponentAdaptor<ChainedComponentModel>> componentModels() {
        return this.componentModels.allComponentsById();
    }
}

