/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.documentapi;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessParams;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.vespa.config.content.LoadTypeConfig;

public class VespaDocumentAccess
extends DocumentAccess {
    private final MessageBusParams parameters;
    private final Object monitor = new Object();
    private DocumentAccess delegate = null;
    private boolean shutDown = false;

    VespaDocumentAccess(DocumentmanagerConfig documentmanagerConfig, LoadTypeConfig loadTypeConfig, SlobroksConfig slobroksConfig, MessagebusConfig messagebusConfig) {
        super(new DocumentAccessParams().setDocumentmanagerConfig(documentmanagerConfig));
        this.parameters = new MessageBusParams(new LoadTypeSet(loadTypeConfig));
        this.parameters.setDocumentmanagerConfig(documentmanagerConfig);
        this.parameters.getRPCNetworkParams().setSlobroksConfig(slobroksConfig);
        this.parameters.getMessageBusParams().setMessageBusConfig(messagebusConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentAccess delegate() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.delegate == null) {
                if (this.shutDown) {
                    throw new IllegalStateException("This document access has been shut down");
                }
                this.delegate = new MessageBusDocumentAccess(this.parameters);
            }
            return this.delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            super.shutdown();
            this.shutDown = true;
            if (this.delegate != null) {
                this.delegate.shutdown();
            }
        }
    }

    public SyncSession createSyncSession(SyncParameters parameters) {
        return this.delegate().createSyncSession(parameters);
    }

    public AsyncSession createAsyncSession(AsyncParameters parameters) {
        return this.delegate().createAsyncSession(parameters);
    }

    public VisitorSession createVisitorSession(VisitorParameters parameters) throws ParseException {
        return this.delegate().createVisitorSession(parameters);
    }

    public VisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters parameters) {
        return this.delegate().createVisitorDestinationSession(parameters);
    }

    public SubscriptionSession createSubscription(SubscriptionParameters parameters) {
        return this.delegate().createSubscription(parameters);
    }

    public SubscriptionSession openSubscription(SubscriptionParameters parameters) {
        return this.delegate().openSubscription(parameters);
    }
}

