/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.core.LogHandlerConfig;
import com.yahoo.container.handler.LogReader;
import com.yahoo.container.jdisc.AsyncHttpResponse;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class LogHandler
extends ThreadedHttpRequestHandler {
    private final LogReader logReader;

    @Inject
    public LogHandler(Executor executor, LogHandlerConfig config) {
        this(executor, new LogReader(config.logDirectory(), config.logPattern()));
    }

    LogHandler(Executor executor, LogReader logReader) {
        super(executor);
        this.logReader = logReader;
    }

    @Override
    public AsyncHttpResponse handle(HttpRequest request) {
        final Instant from = Optional.ofNullable(request.getProperty("from")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        final Instant to = Optional.ofNullable(request.getProperty("to")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MAX);
        final Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
        return new AsyncHttpResponse(200){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void render(OutputStream output, ContentChannel networkChannel, CompletionHandler handler) {
                try {
                    BlockingFlushContentChannelOutputStream blockingOutput = new BlockingFlushContentChannelOutputStream(networkChannel);
                    LogHandler.this.logReader.writeLogs(blockingOutput, from, to, hostname);
                    ((OutputStream)blockingOutput).close();
                }
                catch (Throwable t) {
                    LogHandler.this.log.log(Level.WARNING, "Failed reading logs from " + from + " to " + to, t);
                }
                finally {
                    networkChannel.close(handler);
                }
            }
        };
    }

    private static class BlockingFlushContentChannelOutputStream
    extends ContentChannelOutputStream {
        private final ContentChannel channel;

        public BlockingFlushContentChannelOutputStream(ContentChannel endpoint) {
            super(endpoint);
            this.channel = endpoint;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            final CountDownLatch latch = new CountDownLatch(1);
            this.channel.write(ByteBuffer.allocate(0), new CompletionHandler(){

                public void completed() {
                    latch.countDown();
                }

                public void failed(Throwable t) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted waiting for underlying IO to complete", e);
            }
        }
    }
}

