/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.handler.ClustersStatus;
import com.yahoo.container.jdisc.state.StateMonitor;
import java.util.stream.Collectors;

public class VipStatus {
    private final ClustersStatus clustersStatus;
    private final StateMonitor healthState;
    private Boolean rotationOverride = null;
    private final boolean initiallyInRotation;
    private boolean currentlyInRotation;
    private final Object mutex = new Object();

    public VipStatus() {
        this(new ClustersStatus());
    }

    public VipStatus(QrSearchersConfig dispatchers) {
        this(dispatchers, new ClustersStatus());
    }

    public VipStatus(ClustersStatus clustersStatus) {
        this(new QrSearchersConfig.Builder().build(), clustersStatus);
    }

    public VipStatus(QrSearchersConfig dispatchers, ClustersStatus clustersStatus) {
        this(dispatchers, new VipStatusConfig.Builder().build(), clustersStatus, StateMonitor.createForTesting());
    }

    @Inject
    public VipStatus(QrSearchersConfig dispatchers, VipStatusConfig vipStatusConfig, ClustersStatus clustersStatus, StateMonitor healthState) {
        this.clustersStatus = clustersStatus;
        this.healthState = healthState;
        this.initiallyInRotation = vipStatusConfig.initiallyInRotation();
        clustersStatus.setClusters(dispatchers.searchcluster().stream().map(c -> c.name()).collect(Collectors.toSet()));
        this.updateCurrentlyInRotation();
    }

    @Deprecated
    public VipStatus(QrSearchersConfig dispatchers, ClustersStatus clustersStatus, StateMonitor healthState) {
        this(dispatchers, new VipStatusConfig.Builder().build(), clustersStatus, healthState);
    }

    @Deprecated
    public VipStatus(QrSearchersConfig dispatchers, VipStatusConfig ignored, ClustersStatus clustersStatus) {
        this(dispatchers, clustersStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInRotation(Boolean inRotation) {
        Object object = this.mutex;
        synchronized (object) {
            this.rotationOverride = inRotation;
            this.updateCurrentlyInRotation();
        }
    }

    public void addToRotation(String clusterIdentifier) {
        this.clustersStatus.setUp(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    public void removeFromRotation(String clusterIdentifier) {
        this.clustersStatus.setDown(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    @Deprecated
    public void addToRotation(Object clusterIdentifier) {
        this.addToRotation((String)clusterIdentifier);
    }

    @Deprecated
    public void removeFromRotation(Object clusterIdentifier) {
        this.removeFromRotation((String)clusterIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentlyInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentlyInRotation = this.rotationOverride != null ? this.rotationOverride : (this.healthState.status() == StateMonitor.Status.up ? this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ONE) : (this.healthState.status() == StateMonitor.Status.initializing ? this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ALL) && this.initiallyInRotation : this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ALL)));
            if (this.currentlyInRotation) {
                this.healthState.status(StateMonitor.Status.up);
            } else if (this.healthState.status() == StateMonitor.Status.up) {
                this.healthState.status(StateMonitor.Status.down);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentlyInRotation;
        }
    }
}

