/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.core.LogHandlerConfig;
import com.yahoo.container.handler.LogReader;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class LogHandler
extends ThreadedHttpRequestHandler {
    private final LogReader logReader;

    @Inject
    public LogHandler(Executor executor, LogHandlerConfig config) {
        this(executor, new LogReader(config.logDirectory(), config.logPattern()));
    }

    LogHandler(Executor executor, LogReader logReader) {
        super(executor);
        this.logReader = logReader;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        final Instant from = Optional.ofNullable(request.getProperty("from")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        final Instant to = Optional.ofNullable(request.getProperty("to")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MAX);
        final Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
        return new HttpResponse(200){

            @Override
            public void render(OutputStream outputStream) {
                try {
                    LogHandler.this.logReader.writeLogs(outputStream, from, to, hostname);
                }
                catch (Throwable t) {
                    LogHandler.this.log.log(Level.WARNING, "Failed reading logs from " + from + " to " + to, t);
                }
            }
        };
    }
}

