/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.StateMetricConsumer;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.application.MetricConsumer;
import com.yahoo.jdisc.core.SystemTimer;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateMonitor
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(StateMonitor.class.getName());
    private final CopyOnWriteArrayList<StateMetricConsumer> consumers = new CopyOnWriteArrayList();
    private final Thread thread;
    private final Timer timer;
    private final long snapshotIntervalMs;
    private volatile long lastSnapshotTimeMs;
    private volatile MetricSnapshot snapshot;
    private volatile Status status;
    private final TreeSet<String> valueNames = new TreeSet();
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public StateMonitor() {
        this(new HealthMonitorConfig.Builder().build(), (Timer)new SystemTimer());
    }

    @Inject
    public StateMonitor(HealthMonitorConfig config, Timer timer) {
        this(config, timer, runnable -> {
            Thread thread = new Thread(runnable, "StateMonitor");
            thread.setDaemon(true);
            return thread;
        });
    }

    StateMonitor(HealthMonitorConfig config, Timer timer, ThreadFactory threadFactory) {
        this((long)(config.snapshot_interval() * (double)TimeUnit.SECONDS.toMillis(1L)), Status.valueOf(config.initialStatus()), timer, threadFactory);
    }

    public StateMonitor(long snapshotIntervalMS, Status status, Timer timer, ThreadFactory threadFactory) {
        this.timer = timer;
        this.snapshotIntervalMs = snapshotIntervalMS;
        this.lastSnapshotTimeMs = timer.currentTimeMillis();
        this.status = status;
        this.thread = threadFactory.newThread(this::run);
        this.thread.start();
    }

    public MetricConsumer newMetricConsumer() {
        StateMetricConsumer consumer = new StateMetricConsumer();
        this.consumers.add(consumer);
        return consumer;
    }

    public void status(Status status) {
        if (status != this.status) {
            log.log(Level.INFO, "Changing health status code from '" + this.status + "' to '" + status.name() + "'");
            this.status = status;
        }
    }

    public Status status() {
        return this.status;
    }

    public MetricSnapshot snapshot() {
        return this.snapshot;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMs;
    }

    boolean checkTime() {
        long now = this.timer.currentTimeMillis();
        if (now < this.lastSnapshotTimeMs + this.snapshotIntervalMs) {
            return false;
        }
        this.snapshot = this.createSnapshot(this.lastSnapshotTimeMs, now);
        this.lastSnapshotTimeMs = now;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        log.finest("StateMonitor started.");
        try {
            AtomicBoolean atomicBoolean = this.stopped;
            synchronized (atomicBoolean) {
                while (!this.stopped.get()) {
                    this.checkTime();
                    this.stopped.wait(this.lastSnapshotTimeMs + this.snapshotIntervalMs - this.timer.currentTimeMillis());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.finest("StateMonitor stopped.");
    }

    private MetricSnapshot createSnapshot(long fromMillis, long toMillis) {
        MetricSnapshot snapshot = new MetricSnapshot(fromMillis, toMillis, TimeUnit.MILLISECONDS);
        for (StateMetricConsumer consumer : this.consumers) {
            snapshot.add(consumer.createSnapshot());
        }
        this.updateNames(snapshot);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNames(MetricSnapshot current) {
        TreeSet<String> seen = new TreeSet<String>();
        for (Map.Entry<MetricDimensions, MetricSet> dimensionAndMetric : current) {
            for (Map.Entry<String, MetricValue> nameAndMetric : dimensionAndMetric.getValue()) {
                seen.add(nameAndMetric.getKey());
            }
        }
        TreeSet<String> treeSet = this.valueNames;
        synchronized (treeSet) {
            for (String name : this.valueNames) {
                if (seen.contains(name)) continue;
                current.add((MetricDimensions)StateMetricConsumer.NULL_CONTEXT, name, 0);
            }
            this.valueNames.addAll(seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconstruct() {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            this.stopped.set(true);
            this.stopped.notifyAll();
        }
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.thread.isAlive()) {
            log.warning("StateMonitor failed to terminate within 5 seconds of interrupt signal. Ignoring.");
        }
    }

    public static enum Status {
        up,
        down,
        initializing;

    }
}

