/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.config.FileReference;
import com.yahoo.container.Container;
import com.yahoo.container.core.config.BundleInstaller;
import com.yahoo.container.core.config.BundleStarter;
import com.yahoo.container.core.config.FileAcquirerBundleInstaller;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.osgi.Osgi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;

public class ApplicationBundleLoader {
    private final Map<FileReference, Bundle> reference2Bundle = new LinkedHashMap<FileReference, Bundle>();
    private final Logger log = Logger.getLogger(ApplicationBundleLoader.class.getName());
    private final Osgi osgi;
    private BundleInstaller customBundleInstaller = null;

    public ApplicationBundleLoader(Osgi osgi) {
        this.osgi = osgi;
    }

    public synchronized Set<Bundle> useBundles(List<FileReference> newFileReferences) {
        Set<FileReference> obsoleteReferences = this.getObsoleteFileReferences(newFileReferences);
        Set<Bundle> bundlesToUninstall = this.getObsoleteBundles(obsoleteReferences);
        this.log.info("Bundles to schedule for uninstall: " + bundlesToUninstall);
        this.osgi.allowDuplicateBundles(bundlesToUninstall);
        this.removeInactiveFileReferences(obsoleteReferences);
        this.installBundles(newFileReferences);
        BundleStarter.startBundles(this.reference2Bundle.values());
        this.log.info(this.installedBundlesMessage());
        return bundlesToUninstall;
    }

    private Set<FileReference> getObsoleteFileReferences(List<FileReference> newReferences) {
        HashSet<FileReference> obsoleteReferences = new HashSet<FileReference>(this.reference2Bundle.keySet());
        obsoleteReferences.removeAll(newReferences);
        return obsoleteReferences;
    }

    private Set<Bundle> getObsoleteBundles(Set<FileReference> obsoleteReferences) {
        return obsoleteReferences.stream().map(this.reference2Bundle::get).collect(Collectors.toSet());
    }

    private void removeInactiveFileReferences(Set<FileReference> fileReferencesToRemove) {
        fileReferencesToRemove.forEach(this.reference2Bundle::remove);
    }

    private void installBundles(List<FileReference> references) {
        HashSet<FileReference> bundlesToInstall = new HashSet<FileReference>(references);
        bundlesToInstall.removeAll(this.reference2Bundle.keySet());
        if (!bundlesToInstall.isEmpty()) {
            boolean hasFileDistribution;
            FileAcquirer fileAcquirer = Container.get().getFileAcquirer();
            boolean bl = hasFileDistribution = fileAcquirer != null;
            if (hasFileDistribution) {
                this.installWithFileDistribution(bundlesToInstall, new FileAcquirerBundleInstaller(fileAcquirer));
            } else if (this.customBundleInstaller != null) {
                this.installWithFileDistribution(bundlesToInstall, this.customBundleInstaller);
            } else {
                this.log.warning("Can't retrieve bundles since file distribution is disabled.");
            }
        }
    }

    private void installWithFileDistribution(Set<FileReference> bundlesToInstall, BundleInstaller bundleInstaller) {
        for (FileReference reference : bundlesToInstall) {
            try {
                this.log.info("Installing bundle with reference '" + reference.value() + "'");
                List<Bundle> bundles = bundleInstaller.installBundles(reference, this.osgi);
                if (bundles.size() > 1 && this.osgi.hasFelixFramework() && !bundles.get(0).getSymbolicName().equals("config-model-fat-amended")) {
                    throw new RuntimeException("Bundle '" + bundles.get(0).getSymbolicName() + "' tried to pre-install bundles from disk.");
                }
                this.reference2Bundle.put(reference, bundles.get(0));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle with reference '" + reference + "'", e);
            }
        }
    }

    private String installedBundlesMessage() {
        StringBuilder sb = new StringBuilder("Installed bundles: {");
        for (Bundle b : this.osgi.getBundles()) {
            sb.append("[" + b.getBundleId() + "]" + b.getSymbolicName() + ":" + b.getVersion() + ", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    void useCustomBundleInstaller(BundleInstaller bundleInstaller) {
        this.customBundleInstaller = bundleInstaller;
    }

    List<FileReference> getActiveFileReferences() {
        return new ArrayList<FileReference>(this.reference2Bundle.keySet());
    }
}

