/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.collections.PredicateSplit;
import com.yahoo.config.FileReference;
import com.yahoo.container.Container;
import com.yahoo.container.core.config.BundleInstaller;
import com.yahoo.container.core.config.DiskBundleInstaller;
import com.yahoo.container.core.config.FileAcquirerBundleInstaller;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.osgi.Osgi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class BundleManager {
    private final Map<FileReference, List<Bundle>> reference2Bundles = new LinkedHashMap<FileReference, List<Bundle>>();
    private final Logger log = Logger.getLogger(BundleManager.class.getName());
    private final Osgi osgi;
    private BundleInstaller customBundleInstaller = null;

    public BundleManager(Osgi osgi) {
        this.osgi = osgi;
    }

    public synchronized Set<Bundle> use(List<FileReference> newFileReferences) {
        Set<Bundle> bundlesToUninstall = this.getObsoleteBundles(newFileReferences);
        Set<FileReference> obsoleteReferences = this.getObsoleteFileReferences(newFileReferences);
        this.allowDuplicateBundles(obsoleteReferences);
        this.removeInactiveFileReferences(obsoleteReferences);
        this.installBundles(newFileReferences);
        this.startBundles();
        bundlesToUninstall.removeAll(this.allActiveBundles());
        this.log.info("Bundles to schedule for uninstall: " + bundlesToUninstall);
        this.log.info(this.installedBundlesMessage());
        return bundlesToUninstall;
    }

    private Set<Bundle> getObsoleteBundles(List<FileReference> newReferences) {
        HashSet<Bundle> bundlesToRemove = new HashSet<Bundle>(this.osgi.getCurrentBundles());
        for (FileReference fileReferenceToKeep : newReferences) {
            if (!this.reference2Bundles.containsKey(fileReferenceToKeep)) continue;
            bundlesToRemove.removeAll((Collection)this.reference2Bundles.get(fileReferenceToKeep));
        }
        bundlesToRemove.removeAll(this.osgi.getInitialBundles());
        return bundlesToRemove;
    }

    private Set<FileReference> getObsoleteFileReferences(List<FileReference> newReferences) {
        HashSet<FileReference> obsoleteReferences = new HashSet<FileReference>(this.reference2Bundles.keySet());
        obsoleteReferences.removeAll(newReferences);
        return obsoleteReferences;
    }

    private void allowDuplicateBundles(Set<FileReference> obsoleteReferences) {
        Set<Bundle> allowedDuplicates = obsoleteReferences.stream().filter(reference -> !BundleManager.isDiskBundle(reference)).map(reference -> this.reference2Bundles.get(reference).get(0)).collect(Collectors.toSet());
        this.log.info(() -> allowedDuplicates.isEmpty() ? "" : "Adding bundles to allowed duplicates: " + allowedDuplicates);
        this.osgi.allowDuplicateBundles(allowedDuplicates);
    }

    private void removeInactiveFileReferences(Set<FileReference> fileReferencesToRemove) {
        fileReferencesToRemove.forEach(this.reference2Bundles::remove);
    }

    private void installBundles(List<FileReference> references) {
        HashSet<FileReference> bundlesToInstall = new HashSet<FileReference>(references);
        bundlesToInstall.removeAll(this.reference2Bundles.keySet());
        PredicateSplit bundlesToInstall_isDisk = PredicateSplit.partition(bundlesToInstall, BundleManager::isDiskBundle);
        this.installBundlesFromDisk(bundlesToInstall_isDisk.trueValues);
        this.installBundlesFromFileDistribution(bundlesToInstall_isDisk.falseValues);
    }

    private static boolean isDiskBundle(FileReference fileReference) {
        return fileReference.value().startsWith("file:");
    }

    private void installBundlesFromDisk(List<FileReference> bundlesToInstall) {
        for (FileReference reference : bundlesToInstall) {
            try {
                this.installBundleFromDisk(reference);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle '" + reference + "'", e);
            }
        }
    }

    private void installBundlesFromFileDistribution(List<FileReference> bundlesToInstall) {
        if (!bundlesToInstall.isEmpty()) {
            boolean hasFileDistribution;
            FileAcquirer fileAcquirer = Container.get().getFileAcquirer();
            boolean bl = hasFileDistribution = fileAcquirer != null;
            if (hasFileDistribution) {
                this.installWithFileDistribution(bundlesToInstall, new FileAcquirerBundleInstaller(fileAcquirer));
            } else if (this.customBundleInstaller != null) {
                this.installWithFileDistribution(bundlesToInstall, this.customBundleInstaller);
            } else {
                this.log.warning("Can't retrieve bundles since file distribution is disabled.");
            }
        }
    }

    private void installBundleFromDisk(FileReference reference) {
        this.log.info("Installing bundle from disk with reference '" + reference.value() + "'");
        DiskBundleInstaller bundleInstaller = new DiskBundleInstaller();
        List<Bundle> bundles = bundleInstaller.installBundles(reference, this.osgi);
        this.reference2Bundles.put(reference, bundles);
    }

    private void installWithFileDistribution(List<FileReference> bundlesToInstall, BundleInstaller bundleInstaller) {
        for (FileReference reference : bundlesToInstall) {
            try {
                this.log.info("Installing bundle with reference '" + reference.value() + "'");
                List<Bundle> bundles = bundleInstaller.installBundles(reference, this.osgi);
                this.reference2Bundles.put(reference, bundles);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle '" + reference + "'", e);
            }
        }
    }

    private void startBundles() {
        for (List<Bundle> bundles : this.reference2Bundles.values()) {
            for (Bundle bundle : bundles) {
                try {
                    if (this.isFragment(bundle)) continue;
                    bundle.start();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not start bundle '" + bundle.getSymbolicName() + "'", e);
                }
            }
        }
    }

    private boolean isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision == null) {
            throw new NullPointerException("Null bundle revision means that bundle has probably been uninstalled: " + bundle.getSymbolicName() + ":" + bundle.getVersion());
        }
        return (bundleRevision.getTypes() & 1) != 0;
    }

    private Set<Bundle> allActiveBundles() {
        return this.reference2Bundles.keySet().stream().flatMap(reference -> this.reference2Bundles.get(reference).stream()).collect(Collectors.toSet());
    }

    private String installedBundlesMessage() {
        StringBuilder sb = new StringBuilder("Installed bundles: {");
        for (Bundle b : this.osgi.getBundles()) {
            sb.append("[" + b.getBundleId() + "]" + b.getSymbolicName() + ":" + b.getVersion() + ", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    void useCustomBundleInstaller(BundleInstaller bundleInstaller) {
        this.customBundleInstaller = bundleInstaller;
    }

    List<FileReference> getActiveFileReferences() {
        return new ArrayList<FileReference>(this.reference2Bundles.keySet());
    }
}

