/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.config.FileReference;
import com.yahoo.container.core.config.BundleInstaller;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.osgi.Osgi;
import com.yahoo.protect.Process;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class FileAcquirerBundleInstaller
implements BundleInstaller {
    private static Logger log = Logger.getLogger(FileAcquirerBundleInstaller.class.getName());
    private final FileAcquirer fileAcquirer;

    public FileAcquirerBundleInstaller(FileAcquirer fileAcquirer) {
        this.fileAcquirer = fileAcquirer;
    }

    @Override
    public List<Bundle> installBundles(FileReference reference, Osgi osgi) throws InterruptedException {
        File file = this.fileAcquirer.waitFor(reference, 7L, TimeUnit.DAYS);
        if (FileAcquirerBundleInstaller.notReadable(file)) {
            log.warning("Unable to open bundle file with reference '" + reference + "'. Waiting for up to 5 sec.");
            for (int retries = 0; FileAcquirerBundleInstaller.notReadable(file) && retries < 10; ++retries) {
                Thread.sleep(500L);
            }
            if (FileAcquirerBundleInstaller.notReadable(file)) {
                Process.logAndDie((String)("Shutting down - unable to read bundle file with reference '" + reference + "' and path " + file.getAbsolutePath()));
            }
        }
        return osgi.install(file.getAbsolutePath());
    }

    private static boolean notReadable(File file) {
        return !Files.isReadable(file.toPath());
    }
}

