/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.FileReference;
import com.yahoo.container.Container;
import com.yahoo.container.core.config.BundleManager;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.Osgi;
import com.yahoo.container.di.componentgraph.core.ComponentGraph;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.di.osgi.BundleClasses;
import com.yahoo.container.di.osgi.OsgiUtil;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.util.Util;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.osgi.OsgiImpl;
import com.yahoo.osgi.OsgiWrapper;
import com.yahoo.statistics.Statistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class HandlersConfigurerDi {
    private static final Logger log = Logger.getLogger(HandlersConfigurerDi.class.getName());
    private final Container vespaContainer;
    private final OsgiWrapper osgiWrapper;
    private final com.yahoo.container.di.Container container;
    private volatile ComponentGraph currentGraph = new ComponentGraph(0L);

    public HandlersConfigurerDi(SubscriberFactory subscriberFactory, Container vespaContainer, String configId, ComponentDeconstructor deconstructor, Injector discInjector, OsgiFramework osgiFramework) {
        this(subscriberFactory, vespaContainer, configId, deconstructor, discInjector, new ContainerAndDiOsgi(osgiFramework, new BundleManager(new OsgiImpl(osgiFramework))));
    }

    public HandlersConfigurerDi(SubscriberFactory subscriberFactory, Container vespaContainer, String configId, ComponentDeconstructor deconstructor, Injector discInjector, OsgiWrapper osgiWrapper) {
        this.vespaContainer = vespaContainer;
        this.osgiWrapper = osgiWrapper;
        this.container = new com.yahoo.container.di.Container(subscriberFactory, configId, deconstructor, (Osgi)osgiWrapper);
        this.getNewComponentGraph(discInjector, false);
    }

    public void getNewComponentGraph(Injector discInjector, boolean restartOnRedeploy) {
        this.currentGraph = this.container.getNewComponentGraph(this.currentGraph, this.createFallbackInjector(this.vespaContainer, discInjector), restartOnRedeploy);
    }

    private Injector createFallbackInjector(final Container vespaContainer, Injector discInjector) {
        return discInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Container.class).toInstance((Object)vespaContainer);
                this.bind(Statistics.class).toInstance((Object)Statistics.nullImplementation);
                this.bind(AccessLog.class).toInstance((Object)new AccessLog(new ComponentRegistry()));
                this.bind(Executor.class).toInstance((Object)Executors.newCachedThreadPool(ThreadFactoryFactory.getThreadFactory((String)"HandlersConfigurerDI")));
                if (vespaContainer.getFileAcquirer() != null) {
                    this.bind(FileAcquirer.class).toInstance((Object)vespaContainer.getFileAcquirer());
                }
            }
        }});
    }

    public void reloadConfig(long generation) {
        this.container.reloadConfig(generation);
    }

    public <T> T getComponent(Class<T> componentClass) {
        return (T)this.currentGraph.getInstance(componentClass);
    }

    public void shutdown(ComponentDeconstructor deconstructor) {
        this.container.shutdown(this.currentGraph, deconstructor);
    }

    private static class ContainerAndDiOsgi
    extends OsgiImpl
    implements OsgiWrapper {
        private final OsgiFramework osgiFramework;
        private final BundleManager bundleLoader;

        public ContainerAndDiOsgi(OsgiFramework osgiFramework, BundleManager bundleLoader) {
            super(osgiFramework);
            this.osgiFramework = osgiFramework;
            this.bundleLoader = bundleLoader;
        }

        public BundleClasses getBundleClasses(ComponentSpecification bundleSpec, Set<String> packagesToScan) {
            if (this.osgiFramework.getClass().getName().equals("com.yahoo.application.container.impl.ClassLoaderOsgiFramework")) {
                Bundle syntheticClassPathBundle = (Bundle)CollectionUtil.first((Collection)this.osgiFramework.bundles());
                ClassLoader classLoader = ((BundleWiring)syntheticClassPathBundle.adapt(BundleWiring.class)).getClassLoader();
                return new BundleClasses(syntheticClassPathBundle, OsgiUtil.getClassEntriesForBundleUsingProjectClassPathMappings((ClassLoader)classLoader, (ComponentSpecification)bundleSpec, packagesToScan));
            }
            Bundle bundle = this.getBundle(bundleSpec);
            if (bundle == null) {
                throw new RuntimeException("No bundle matching " + Util.quote((Object)bundleSpec));
            }
            return new BundleClasses(bundle, OsgiUtil.getClassEntriesInBundleClassPath((Bundle)bundle, packagesToScan));
        }

        public Set<Bundle> useBundles(Collection<FileReference> bundles) {
            log.info("Installing bundles from the latest application");
            return this.bundleLoader.use(new ArrayList<FileReference>(bundles));
        }
    }

    public static class RegistriesHack {
        @Inject
        public RegistriesHack(Container vespaContainer, ComponentRegistry<AbstractComponent> allComponents, ComponentRegistry<RequestHandler> requestHandlerRegistry, ComponentRegistry<ClientProvider> clientProviderRegistry, ComponentRegistry<ServerProvider> serverProviderRegistry) {
            log.log(Level.FINE, "RegistriesHack.init " + System.identityHashCode(this));
            vespaContainer.setComponentRegistry(allComponents);
            vespaContainer.setRequestHandlerRegistry(requestHandlerRegistry);
            vespaContainer.setClientProviderRegistry(clientProviderRegistry);
            vespaContainer.setServerProviderRegistry(serverProviderRegistry);
        }
    }
}

