/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.vespa.defaults.Defaults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class LogReader {
    static final Pattern logArchivePathPattern = Pattern.compile("(\\d{4})/(\\d{2})/(\\d{2})/(\\d{2})-\\d+(.gz)?");
    static final Pattern vespaLogPathPattern = Pattern.compile("vespa\\.log(?:-(\\d{4})-(\\d{2})-(\\d{2})\\.(\\d{2})-(\\d{2})-(\\d{2})(?:.gz)?)?");
    private final Path logDirectory;
    private final Pattern logFilePattern;

    LogReader(String logDirectory, String logFilePattern) {
        this(Paths.get(Defaults.getDefaults().underVespaHome(logDirectory), new String[0]), Pattern.compile(logFilePattern));
    }

    LogReader(Path logDirectory, Pattern logFilePattern) {
        this.logDirectory = logDirectory;
        this.logFilePattern = logFilePattern;
    }

    void writeLogs(OutputStream outputStream, Instant from, Instant to) {
        try {
            List<List<Path>> logs = this.getMatchingFiles(from, to);
            for (int i = 0; i < logs.size(); ++i) {
                for (Path log : logs.get(i)) {
                    boolean zipped = log.toString().endsWith(".gz");
                    InputStream in = Files.newInputStream(log, new OpenOption[0]);
                    try {
                        InputStream inProxy;
                        ByteArrayOutputStream buffer;
                        if (i == 0 || i == logs.size() - 1) {
                            buffer = new ByteArrayOutputStream();
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipped ? new GZIPInputStream(in) : in, StandardCharsets.UTF_8));
                                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zipped ? new GZIPOutputStream(buffer) : buffer, StandardCharsets.UTF_8));){
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    Instant at;
                                    String[] parts = line.split("\t");
                                    if (parts.length != 7 || !(at = Instant.EPOCH.plus((long)(Double.parseDouble(parts[0]) * 1000000.0), ChronoUnit.MICROS)).isAfter(from) || at.isAfter(to)) continue;
                                    writer.write(line);
                                    writer.newLine();
                                }
                            }
                            inProxy = new ByteArrayInputStream(buffer.toByteArray());
                        } else {
                            inProxy = in;
                        }
                        if (!zipped) {
                            buffer = new ByteArrayOutputStream();
                            try (GZIPOutputStream outProxy = new GZIPOutputStream(buffer);){
                                inProxy.transferTo(outProxy);
                            }
                            inProxy = new ByteArrayInputStream(buffer.toByteArray());
                        }
                        inProxy.transferTo(outputStream);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<List<Path>> getMatchingFiles(Instant from, Instant to) {
        final ArrayList paths = new ArrayList();
        try {
            Files.walkFileTree(this.logDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (LogReader.this.logFilePattern.matcher(file.getFileName().toString()).matches()) {
                        paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        TreeMap logsByTimestamp = paths.stream().collect(Collectors.groupingBy(this::extractTimestamp, TreeMap::new, Collectors.toList()));
        ArrayList<List<Path>> sorted = new ArrayList<List<Path>>();
        for (Map.Entry entry : logsByTimestamp.entrySet()) {
            if (((Instant)entry.getKey()).isAfter(from)) {
                sorted.add((List)entry.getValue());
            }
            if (!((Instant)entry.getKey()).isAfter(to)) continue;
            break;
        }
        return sorted;
    }

    Instant extractTimestamp(Path path) {
        String relativePath = this.logDirectory.relativize(path).toString();
        Matcher matcher = logArchivePathPattern.matcher(relativePath);
        if (matcher.matches()) {
            return ZonedDateTime.of(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), 0, 0, 0, ZoneId.of("UTC")).toInstant().plus(Duration.ofHours(1L));
        }
        matcher = vespaLogPathPattern.matcher(relativePath);
        if (matcher.matches()) {
            if (matcher.group(1) == null) {
                return Instant.MAX;
            }
            return ZonedDateTime.of(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), 0, ZoneId.of("UTC")).toInstant().plus(Duration.ofSeconds(1L));
        }
        throw new IllegalArgumentException("Unrecognized file pattern for file at '" + path + "'");
    }
}

