/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ExecutorServiceWrapper;
import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import com.yahoo.container.handler.threadpool.WorkerCompletionTimingThreadPoolExecutor;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class ContainerThreadPool
implements AutoCloseable {
    private final ExecutorServiceWrapper threadpool;

    public ContainerThreadPool(ThreadpoolConfig config, Metric metric) {
        this(config, metric, new ProcessTerminator());
    }

    public ContainerThreadPool(ThreadpoolConfig threadpoolConfig, Metric metric, ProcessTerminator processTerminator) {
        ThreadPoolMetric threadPoolMetric = new ThreadPoolMetric(metric, threadpoolConfig.name());
        int maxNumThreads = ContainerThreadPool.computeMaximumThreadPoolSize(threadpoolConfig.maxthreads());
        int coreNumThreads = ContainerThreadPool.computeCoreThreadPoolSize(threadpoolConfig.corePoolSize(), maxNumThreads);
        WorkerCompletionTimingThreadPoolExecutor executor = new WorkerCompletionTimingThreadPoolExecutor(coreNumThreads, maxNumThreads, (long)((int)threadpoolConfig.keepAliveTime() * 1000), TimeUnit.MILLISECONDS, ContainerThreadPool.createQ(threadpoolConfig.queueSize(), maxNumThreads), ThreadFactoryFactory.getThreadFactory((String)threadpoolConfig.name()), threadPoolMetric);
        executor.prestartAllCoreThreads();
        this.threadpool = new ExecutorServiceWrapper(executor, threadPoolMetric, processTerminator, (long)threadpoolConfig.maxThreadExecutionTimeSeconds() * 1000L);
    }

    public Executor executor() {
        return this.threadpool;
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    private void closeInternal() {
        boolean terminated;
        this.threadpool.shutdown();
        try {
            terminated = this.threadpool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (!terminated) {
            this.threadpool.shutdownNow();
        }
    }

    private static BlockingQueue<Runnable> createQ(int queueSize, int maxThreads) {
        return queueSize == 0 ? new SynchronousQueue(false) : (queueSize < 0 ? new ArrayBlockingQueue(maxThreads * 4) : new ArrayBlockingQueue(queueSize));
    }

    private static int computeMaximumThreadPoolSize(int maxNumThreads) {
        return maxNumThreads <= 0 ? Runtime.getRuntime().availableProcessors() * 4 : maxNumThreads;
    }

    private static int computeCoreThreadPoolSize(int corePoolSize, int maxNumThreads) {
        return Math.min(corePoolSize, maxNumThreads);
    }
}

