/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.Vtag;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.JSONObjectWithLegibleException;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.container.jdisc.state.StateMetricContext;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.metrics.MetricsPresentationConfig;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StateHandler
extends AbstractRequestHandler {
    public static final String STATE_API_ROOT = "/state/v1";
    private static final String METRICS_PATH = "metrics";
    private static final String HISTOGRAMS_PATH = "metrics/histograms";
    private static final String CONFIG_GENERATION_PATH = "config";
    private static final String HEALTH_PATH = "health";
    private static final String VERSION_PATH = "version";
    private static final MetricDimensions NULL_DIMENSIONS = StateMetricContext.newInstance(null);
    private final StateMonitor monitor;
    private final Timer timer;
    private final byte[] config;
    private final SnapshotProvider snapshotPreprocessor;

    @Inject
    public StateHandler(StateMonitor monitor, Timer timer, ApplicationMetadataConfig config, ComponentRegistry<SnapshotProvider> preprocessors, MetricsPresentationConfig presentation) {
        this.monitor = monitor;
        this.timer = timer;
        this.config = StateHandler.buildConfigOutput(config);
        this.snapshotPreprocessor = StateHandler.getSnapshotPreprocessor(preprocessors, presentation);
    }

    static SnapshotProvider getSnapshotPreprocessor(ComponentRegistry<SnapshotProvider> preprocessors, MetricsPresentationConfig presentation) {
        List allPreprocessors = preprocessors.allComponents();
        if (presentation.slidingwindow() && allPreprocessors.size() > 0) {
            return (SnapshotProvider)allPreprocessors.get(0);
        }
        return null;
    }

    public ContentChannel handleRequest(final Request request, ResponseHandler handler) {
        new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", StateHandler.this.resolveContentType(request.getUri()));
                return response;
            }

            protected Iterable<ByteBuffer> responseContent() {
                return Collections.singleton(StateHandler.this.buildContent(request.getUri()));
            }
        }.dispatch(handler);
        return null;
    }

    private String resolveContentType(URI requestUri) {
        if (StateHandler.resolvePath(requestUri).equals(HISTOGRAMS_PATH)) {
            return "text/plain; charset=utf-8";
        }
        return "application/json";
    }

    private ByteBuffer buildContent(URI requestUri) {
        String suffix;
        switch (suffix = StateHandler.resolvePath(requestUri)) {
            case "": {
                return ByteBuffer.wrap(this.apiLinks(requestUri));
            }
            case "config": {
                return ByteBuffer.wrap(this.config);
            }
            case "metrics/histograms": {
                return ByteBuffer.wrap(this.buildHistogramsOutput());
            }
            case "health": 
            case "metrics": {
                return ByteBuffer.wrap(this.buildMetricOutput(suffix));
            }
            case "version": {
                return ByteBuffer.wrap(StateHandler.buildVersionOutput());
            }
        }
        return ByteBuffer.wrap(this.buildMetricOutput(suffix));
    }

    private byte[] apiLinks(URI requestUri) {
        try {
            int port = requestUri.getPort();
            String host = requestUri.getHost();
            StringBuilder base = new StringBuilder("http://");
            base.append(host);
            if (port != -1) {
                base.append(":").append(port);
            }
            base.append(STATE_API_ROOT);
            String uriBase = base.toString();
            JSONArray linkList = new JSONArray();
            for (String api : new String[]{METRICS_PATH, CONFIG_GENERATION_PATH, HEALTH_PATH, VERSION_PATH}) {
                JSONObject resource = new JSONObject();
                resource.put("url", (Object)(uriBase + "/" + api));
                linkList.put((Object)resource);
            }
            return new JSONObjectWithLegibleException().put("resources", linkList).toString(4).getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private static String resolvePath(URI uri) {
        String path = uri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith(STATE_API_ROOT)) {
            path = path.substring(STATE_API_ROOT.length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static byte[] buildConfigOutput(ApplicationMetadataConfig config) {
        try {
            return new JSONObjectWithLegibleException().put(CONFIG_GENERATION_PATH, new JSONObjectWithLegibleException().put("generation", config.generation()).put("container", (Object)new JSONObjectWithLegibleException().put("generation", config.generation()))).toString(4).getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private static byte[] buildVersionOutput() {
        try {
            return new JSONObjectWithLegibleException().put(VERSION_PATH, Vtag.currentVersion).toString(4).getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private byte[] buildMetricOutput(String consumer) {
        try {
            return this.buildJsonForConsumer(consumer).toString(4).getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new RuntimeException("Bad JSON construction.", e);
        }
    }

    private byte[] buildHistogramsOutput() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.snapshotPreprocessor != null) {
            this.snapshotPreprocessor.histogram(new PrintStream(baos));
        }
        return baos.toByteArray();
    }

    private JSONObjectWithLegibleException buildJsonForConsumer(String consumer) throws JSONException {
        JSONObjectWithLegibleException ret = new JSONObjectWithLegibleException();
        ret.put("time", this.timer.currentTimeMillis());
        ret.put("status", new JSONObjectWithLegibleException().put("code", this.getStatus().name()));
        ret.put(METRICS_PATH, (Object)this.buildJsonForSnapshot(consumer, this.getSnapshot()));
        return ret;
    }

    private MetricSnapshot getSnapshot() {
        if (this.snapshotPreprocessor == null) {
            return this.monitor.snapshot();
        }
        return this.snapshotPreprocessor.latestSnapshot();
    }

    private StateMonitor.Status getStatus() {
        return this.monitor.status();
    }

    private JSONObjectWithLegibleException buildJsonForSnapshot(String consumer, MetricSnapshot metricSnapshot) throws JSONException {
        if (metricSnapshot == null) {
            return new JSONObjectWithLegibleException();
        }
        JSONObjectWithLegibleException jsonMetric = new JSONObjectWithLegibleException();
        jsonMetric.put("snapshot", new JSONObjectWithLegibleException().put("from", (double)metricSnapshot.getFromTime(TimeUnit.MILLISECONDS) / 1000.0).put("to", (double)metricSnapshot.getToTime(TimeUnit.MILLISECONDS) / 1000.0));
        boolean includeDimensions = !consumer.equals(HEALTH_PATH);
        long periodInMillis = metricSnapshot.getToTime(TimeUnit.MILLISECONDS) - metricSnapshot.getFromTime(TimeUnit.MILLISECONDS);
        for (Tuple tuple : StateHandler.collapseMetrics(metricSnapshot, consumer)) {
            JSONObjectWithLegibleException jsonTuple = new JSONObjectWithLegibleException();
            jsonTuple.put("name", tuple.key);
            if (tuple.val instanceof CountMetric) {
                CountMetric count = (CountMetric)tuple.val;
                jsonTuple.put("values", new JSONObjectWithLegibleException().put("count", count.getCount()).put("rate", (double)count.getCount() * 1000.0 / (double)periodInMillis));
            } else if (tuple.val instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)tuple.val;
                JSONObjectWithLegibleException valueFields = new JSONObjectWithLegibleException();
                valueFields.put("average", gauge.getAverage()).put("sum", gauge.getSum()).put("count", gauge.getCount()).put("last", gauge.getLast()).put("max", gauge.getMax()).put("min", gauge.getMin()).put("rate", (double)gauge.getCount() * 1000.0 / (double)periodInMillis);
                if (gauge.getPercentiles().isPresent()) {
                    for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                        valueFields.put((String)prefixAndValue.first + "percentile", (Double)prefixAndValue.second);
                    }
                }
                jsonTuple.put("values", (Object)valueFields);
            } else {
                throw new UnsupportedOperationException(tuple.val.getClass().getName());
            }
            Iterator it = tuple.dim.iterator();
            if (it.hasNext() && includeDimensions) {
                JSONObjectWithLegibleException jsonDim = new JSONObjectWithLegibleException();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    jsonDim.put((String)entry.getKey(), entry.getValue());
                }
                jsonTuple.put("dimensions", (Object)jsonDim);
            }
            jsonMetric.append("values", (Object)jsonTuple);
        }
        return jsonMetric;
    }

    private static List<Tuple> collapseMetrics(MetricSnapshot snapshot, String consumer) {
        switch (consumer) {
            case "health": {
                return StateHandler.collapseHealthMetrics(snapshot);
            }
            case "all": 
            case "metrics": {
                return StateHandler.flattenAllMetrics(snapshot);
            }
        }
        throw new IllegalArgumentException("Unknown consumer '" + consumer + "'.");
    }

    private static List<Tuple> collapseHealthMetrics(MetricSnapshot snapshot) {
        Tuple requestsPerSecond = new Tuple(NULL_DIMENSIONS, "requestsPerSecond", null);
        Tuple latencySeconds = new Tuple(NULL_DIMENSIONS, "latencySeconds", null);
        for (Map.Entry<MetricDimensions, MetricSet> entry : snapshot) {
            MetricSet metricSet = entry.getValue();
            MetricValue val = metricSet.get("serverTotalSuccessfulResponseLatency");
            if (val instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)val;
                latencySeconds.add(GaugeMetric.newInstance(gauge.getLast() / 1000.0, gauge.getMax() / 1000.0, gauge.getMin() / 1000.0, gauge.getSum() / 1000.0, gauge.getCount()));
            }
            requestsPerSecond.add(metricSet.get("serverNumSuccessfulResponses"));
        }
        ArrayList<Tuple> lst = new ArrayList<Tuple>();
        if (requestsPerSecond.val != null) {
            lst.add(requestsPerSecond);
        }
        if (latencySeconds.val != null) {
            lst.add(latencySeconds);
        }
        return lst;
    }

    static List<Tuple> flattenAllMetrics(MetricSnapshot snapshot) {
        ArrayList<Tuple> metrics = new ArrayList<Tuple>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : snapshot) {
            for (Map.Entry<String, MetricValue> metricSetEntry : snapshotEntry.getValue()) {
                metrics.add(new Tuple(snapshotEntry.getKey(), metricSetEntry.getKey(), metricSetEntry.getValue()));
            }
        }
        return metrics;
    }

    static class Tuple {
        final MetricDimensions dim;
        final String key;
        MetricValue val;

        Tuple(MetricDimensions dim, String key, MetricValue val) {
            this.dim = dim;
            this.key = key;
            this.val = val;
        }

        void add(MetricValue val) {
            if (val == null) {
                return;
            }
            if (this.val == null) {
                this.val = val;
            } else {
                this.val.add(val);
            }
        }
    }
}

