/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReader {
    long earliestLogThreshold;
    long latestLogThreshold;

    protected JSONObject readLogs(String logDirectory, long earliestLogThreshold, long latestLogThreshold) throws IOException, JSONException {
        this.earliestLogThreshold = earliestLogThreshold;
        this.latestLogThreshold = latestLogThreshold + Duration.ofMinutes(5L).toMillis();
        JSONObject json = new JSONObject();
        File root = new File(logDirectory);
        this.traverse_folder(root, json, "");
        return json;
    }

    private void traverse_folder(File root, JSONObject json, String filename) throws IOException, JSONException {
        File[] files;
        for (File child : files = root.listFiles()) {
            long logTime = Files.getLastModifiedTime(child.toPath(), new LinkOption[0]).toMillis();
            if (child.isFile() && this.earliestLogThreshold < logTime && logTime < this.latestLogThreshold) {
                json.put(filename + child.getName(), (Object)Base64.getEncoder().encodeToString(Files.readAllBytes(child.toPath())));
                continue;
            }
            if (child.isFile()) continue;
            this.traverse_folder(child, json, filename + child.getName() + "-");
        }
    }
}

