/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.inject.Inject;
import com.yahoo.container.jdisc.AsyncHttpResponse;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.container.jdisc.EmptyResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingCompletionHandler;
import com.yahoo.container.jdisc.ThreadedRequestHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.handler.UnsafeContentInputStream;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ThreadedHttpRequestHandler
extends ThreadedRequestHandler {
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String RENDERING_ERRORS = "rendering_errors";
    private static final String UNHANDLED_EXCEPTIONS_METRIC = "jdisc.http.handler.unhandled_exceptions";
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public ThreadedHttpRequestHandler(Executor executor) {
        this(executor, null);
    }

    @Inject
    public ThreadedHttpRequestHandler(Executor executor, Metric metric) {
        this(executor, metric, false);
    }

    public ThreadedHttpRequestHandler(Executor executor, Metric metric, boolean allowAsyncResponse) {
        super(executor, metric, allowAsyncResponse);
    }

    public abstract HttpResponse handle(HttpRequest var1);

    public HttpResponse handle(HttpRequest request, ContentChannel channel) {
        return this.handle(request);
    }

    @Override
    public final void handleRequest(Request request, BufferedContentChannel requestContent, ResponseHandler responseHandler) {
        if (this.log.isLoggable((Level)LogLevel.DEBUG)) {
            this.log.log((Level)LogLevel.DEBUG, "In " + ((Object)((Object)this)).getClass() + ".handleRequest()");
        }
        com.yahoo.jdisc.http.HttpRequest jdiscRequest = this.asHttpRequest(request);
        HttpRequest httpRequest = new HttpRequest(jdiscRequest, (InputStream)new UnsafeContentInputStream(requestContent.toReadable()));
        LazyContentChannel channel = null;
        try {
            channel = new LazyContentChannel(httpRequest, responseHandler, this.metric, this.log);
            HttpResponse httpResponse = this.handle(httpRequest, channel);
            channel.setHttpResponse(httpResponse);
            this.render(httpRequest, httpResponse, channel, jdiscRequest.creationTime(TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            this.metric.add(UNHANDLED_EXCEPTIONS_METRIC, (Number)1L, this.contextFor(request, Map.of("exception", e.getClass().getSimpleName())));
            this.metric.add(RENDERING_ERRORS, (Number)1, null);
            this.log.log((Level)LogLevel.ERROR, "Uncaught exception handling request", e);
            if (channel != null) {
                channel.setHttpResponse(null);
                channel.close(null);
            }
        }
        catch (Error e) {
            Process.logAndDie((String)"java.lang.Error handling request", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(HttpRequest request, HttpResponse httpResponse, LazyContentChannel channel, long startTime) {
        LoggingCompletionHandler logOnCompletion;
        block12: {
            logOnCompletion = null;
            ContentChannelOutputStream output = null;
            try {
                output = new ContentChannelOutputStream(channel);
                logOnCompletion = this.createLoggingCompletionHandler(startTime, System.currentTimeMillis(), httpResponse, request, output);
                this.addResponseHeaders(httpResponse, startTime);
                if (httpResponse instanceof AsyncHttpResponse) {
                    ((AsyncHttpResponse)httpResponse).render(output, channel, logOnCompletion);
                    break block12;
                }
                httpResponse.render(output);
                if (logOnCompletion != null) {
                    logOnCompletion.markCommitStart();
                }
                output.flush();
            }
            catch (IOException e) {
                try {
                    this.metric.add(RENDERING_ERRORS, (Number)1, null);
                    long time = System.currentTimeMillis() - startTime;
                    this.log.log(time < 900L ? LogLevel.INFO : LogLevel.WARNING, "IO error while responding to  [" + request.getUri() + "] (total time " + time + " ms) ", e);
                    try {
                        if (output != null) {
                            output.flush();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    if (channel != null && !(httpResponse instanceof AsyncHttpResponse)) {
                        channel.close(logOnCompletion);
                    }
                    throw throwable;
                }
                if (channel != null && !(httpResponse instanceof AsyncHttpResponse)) {
                    channel.close(logOnCompletion);
                }
            }
        }
        if (channel != null && !(httpResponse instanceof AsyncHttpResponse)) {
            channel.close(logOnCompletion);
        }
    }

    private void addResponseHeaders(HttpResponse httpResponse, long startTime) {
        if (!httpResponse.headers().containsKey((Object)CONTENT_TYPE) && httpResponse.getContentType() != null) {
            StringBuilder s = new StringBuilder(httpResponse.getContentType());
            if (httpResponse.getCharacterEncoding() != null) {
                s.append("; charset=").append(httpResponse.getCharacterEncoding());
            }
            httpResponse.headers().put(CONTENT_TYPE, s.toString());
        }
        this.addDateHeader(httpResponse, startTime);
    }

    protected void addDateHeader(HttpResponse httpResponse, long startTime) {
    }

    protected LoggingCompletionHandler createLoggingCompletionHandler(long startTime, long renderStartTime, HttpResponse response, HttpRequest httpRequest, ContentChannelOutputStream rendererWiring) {
        return null;
    }

    protected com.yahoo.jdisc.http.HttpRequest asHttpRequest(Request request) {
        if (!(request instanceof com.yahoo.jdisc.http.HttpRequest)) {
            throw new IllegalArgumentException("Expected " + com.yahoo.jdisc.http.HttpRequest.class.getName() + ", got " + request.getClass().getName());
        }
        return (com.yahoo.jdisc.http.HttpRequest)request;
    }

    public static class LazyContentChannel
    implements ContentChannel {
        private ContentChannel channel = null;
        private boolean closed = false;
        private HttpRequest httpRequest;
        private HttpResponse httpResponse;
        private final ResponseHandler responseHandler;
        private final Metric metric;
        private final Logger log;

        public LazyContentChannel(HttpRequest httpRequest, ResponseHandler responseHandler, Metric metric, Logger log) {
            this.httpRequest = httpRequest;
            this.responseHandler = responseHandler;
            this.metric = metric;
            this.log = log;
        }

        public void setHttpResponse(HttpResponse httpResponse) {
            if (httpResponse == null && this.httpResponse == null) {
                httpResponse = new EmptyResponse(500);
            }
            this.httpResponse = httpResponse;
        }

        public void write(ByteBuffer byteBuffer, CompletionHandler completionHandler) {
            if (this.channel == null) {
                this.channel = this.handleResponse();
            }
            this.channel.write(byteBuffer, completionHandler);
        }

        public void close(CompletionHandler completionHandler) {
            if (this.closed) {
                return;
            }
            try {
                this.httpRequest.getData().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.channel == null) {
                this.channel = this.handleResponse();
            }
            try {
                this.channel.close(completionHandler);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.closed = true;
        }

        private ContentChannel handleResponse() {
            try {
                if (this.httpResponse == null) {
                    throw new NullPointerException("Writing to a lazy content channel without calling setHttpResponse first");
                }
                this.httpResponse.complete();
                return this.responseHandler.handleResponse(this.httpResponse.getJdiscResponse());
            }
            catch (Exception e) {
                this.metric.add(ThreadedHttpRequestHandler.RENDERING_ERRORS, (Number)1, null);
                if (this.log.isLoggable((Level)LogLevel.DEBUG)) {
                    this.log.log((Level)LogLevel.DEBUG, "Error writing response to client - connection probably terminated from client side.", e);
                }
                return new DevNullChannel();
            }
        }

        private static class DevNullChannel
        implements ContentChannel {
            private DevNullChannel() {
            }

            public void write(ByteBuffer byteBuffer, CompletionHandler completionHandler) {
            }

            public void close(CompletionHandler completionHandler) {
            }
        }
    }
}

