/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.common.util.concurrent.ForwardingExecutorService;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolProvider
extends AbstractComponent
implements Provider<Executor> {
    private final ExecutorServiceWrapper threadpool;

    @Inject
    public ThreadPoolProvider(ThreadpoolConfig threadpoolConfig, Metric metric) {
        this(threadpoolConfig, metric, new ProcessTerminator());
    }

    public ThreadPoolProvider(ThreadpoolConfig threadpoolConfig, Metric metric, ProcessTerminator processTerminator) {
        WorkerCompletionTimingThreadPoolExecutor executor = new WorkerCompletionTimingThreadPoolExecutor(threadpoolConfig.maxthreads(), threadpoolConfig.maxthreads(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(false), ThreadFactoryFactory.getThreadFactory((String)"threadpool"), metric);
        executor.prestartAllCoreThreads();
        this.threadpool = new ExecutorServiceWrapper(executor, metric, processTerminator, (long)threadpoolConfig.maxThreadExecutionTimeSeconds() * 1000L);
    }

    public Executor get() {
        return this.threadpool;
    }

    public void deconstruct() {
        boolean terminated;
        super.deconstruct();
        this.threadpool.shutdown();
        try {
            terminated = this.threadpool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (!terminated) {
            this.threadpool.shutdownNow();
        }
    }

    private static final class WorkerCompletionTimingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final String UNHANDLED_EXCEPTIONS_METRIC = "jdisc.thread_pool.unhandled_exceptions";
        volatile long lastThreadAssignmentTimeMillis = System.currentTimeMillis();
        private final AtomicLong startedCount = new AtomicLong(0L);
        private final AtomicLong completedCount = new AtomicLong(0L);
        private final Metric metric;

        public WorkerCompletionTimingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Metric metric) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.metric = metric;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.lastThreadAssignmentTimeMillis = System.currentTimeMillis();
            this.startedCount.incrementAndGet();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.completedCount.incrementAndGet();
            if (t != null) {
                this.metric.add(UNHANDLED_EXCEPTIONS_METRIC, (Number)1L, this.metric.createContext(Map.of("exception", t.getClass().getSimpleName())));
            }
        }

        @Override
        public int getActiveCount() {
            return (int)(this.startedCount.get() - this.completedCount.get());
        }
    }

    private static final class ExecutorServiceWrapper
    extends ForwardingExecutorService {
        private final WorkerCompletionTimingThreadPoolExecutor wrapped;
        private final Metric metric;
        private final ProcessTerminator processTerminator;
        private final long maxThreadExecutionTimeMillis;
        private final Thread metricReporter;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private ExecutorServiceWrapper(WorkerCompletionTimingThreadPoolExecutor wrapped, Metric metric, ProcessTerminator processTerminator, long maxThreadExecutionTimeMillis) {
            this.wrapped = wrapped;
            this.metric = metric;
            this.processTerminator = processTerminator;
            this.maxThreadExecutionTimeMillis = maxThreadExecutionTimeMillis;
            metric.set("serverThreadPoolSize", (Number)wrapped.getPoolSize(), null);
            metric.set("serverActiveThreads", (Number)wrapped.getActiveCount(), null);
            metric.add("serverRejectedRequests", (Number)0, null);
            this.metricReporter = new Thread(this::reportMetrics);
            this.metricReporter.setDaemon(true);
            this.metricReporter.start();
        }

        private final void reportMetrics() {
            try {
                while (!this.closed.get()) {
                    this.metric.set("serverThreadPoolSize", (Number)this.wrapped.getPoolSize(), null);
                    this.metric.set("serverActiveThreads", (Number)this.wrapped.getActiveCount(), null);
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            super.shutdown();
            this.closed.set(true);
        }

        public void execute(Runnable command) {
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException e) {
                this.metric.add("serverRejectedRequests", (Number)1, null);
                long timeSinceLastReturnedThreadMillis = System.currentTimeMillis() - this.wrapped.lastThreadAssignmentTimeMillis;
                if (timeSinceLastReturnedThreadMillis > this.maxThreadExecutionTimeMillis) {
                    this.processTerminator.logAndDie("No worker threads have been available for " + timeSinceLastReturnedThreadMillis + " ms. Shutting down.", true);
                }
                throw e;
            }
        }

        protected ExecutorService delegate() {
            return this.wrapped;
        }

        private static final class MetricNames {
            private static final String REJECTED_REQUEST = "serverRejectedRequests";
            private static final String THREAD_POOL_SIZE = "serverThreadPoolSize";
            private static final String ACTIVE_THREADS = "serverActiveThreads";

            private MetricNames() {
            }
        }
    }
}

