/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.handler;

import com.google.common.annotations.Beta;
import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.jdisc.RequestHandlerTestDriver;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.logging.AccessLogInterface;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.processing.Processor;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingHandler;
import com.yahoo.processing.rendering.Renderer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Beta
public class ProcessingTestDriver
extends RequestHandlerTestDriver {
    private final ProcessingHandler processingHandler;

    public ProcessingTestDriver(Collection<Chain<Processor>> chains) {
        this(chains, (ComponentRegistry<Renderer>)new ComponentRegistry());
    }

    public ProcessingTestDriver(String binding, Collection<Chain<Processor>> chains) {
        this(chains, (ComponentRegistry<Renderer>)new ComponentRegistry());
    }

    @SafeVarargs
    public ProcessingTestDriver(Chain<Processor> ... chains) {
        this(Arrays.asList(chains), (ComponentRegistry<Renderer>)new ComponentRegistry());
    }

    @SafeVarargs
    public ProcessingTestDriver(String binding, Chain<Processor> ... chains) {
        this(binding, Arrays.asList(chains), (ComponentRegistry<Renderer>)new ComponentRegistry());
    }

    public ProcessingTestDriver(Collection<Chain<Processor>> chains, ComponentRegistry<Renderer> renderers) {
        this(ProcessingTestDriver.createProcessingHandler(chains, renderers, AccessLog.voidAccessLog()));
    }

    public ProcessingTestDriver(String binding, Collection<Chain<Processor>> chains, ComponentRegistry<Renderer> renderers) {
        this(binding, ProcessingTestDriver.createProcessingHandler(chains, renderers, AccessLog.voidAccessLog()));
    }

    public ProcessingTestDriver(ProcessingHandler processingHandler) {
        super((RequestHandler)processingHandler);
        this.processingHandler = processingHandler;
    }

    public ProcessingTestDriver(String binding, ProcessingHandler processingHandler) {
        super(binding, (RequestHandler)processingHandler);
        this.processingHandler = processingHandler;
    }

    public ProcessingTestDriver(Chain<Processor> chain, AccessLogInterface accessLogInterface) {
        this(ProcessingTestDriver.createProcessingHandler(Collections.singleton(chain), (ComponentRegistry<Renderer>)new ComponentRegistry(), ProcessingTestDriver.createAccessLog(accessLogInterface)));
    }

    private static AccessLog createAccessLog(AccessLogInterface accessLogInterface) {
        ComponentRegistry componentRegistry = new ComponentRegistry();
        componentRegistry.register(ComponentId.createAnonymousComponentId((String)"access-log"), (Object)accessLogInterface);
        componentRegistry.freeze();
        return new AccessLog(componentRegistry);
    }

    private static ProcessingHandler createProcessingHandler(Collection<Chain<Processor>> chains, ComponentRegistry<Renderer> renderers, AccessLog accessLog) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ChainRegistry registry = new ChainRegistry();
        for (Chain<Processor> chain : chains) {
            registry.register(chain.getId(), chain);
        }
        return new ProcessingHandler((ChainRegistry<Processor>)registry, renderers, (Executor)executor, accessLog);
    }

    public ProcessingHandler processingHandler() {
        return this.processingHandler;
    }
}

