/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import java.util.HashMap;
import java.util.Map;

public class ClustersStatus
extends AbstractComponent {
    private boolean containerHasClusters;
    private final Object mutex = new Object();
    private final Map<String, Boolean> clusterStatus = new HashMap<String, Boolean>();

    @Inject
    public ClustersStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerHasClusters(boolean containerHasClusters) {
        Object object = this.mutex;
        synchronized (object) {
            this.containerHasClusters = containerHasClusters;
            if (!containerHasClusters) {
                this.clusterStatus.clear();
            }
        }
    }

    @Deprecated
    public void setReceiveTrafficByDefault(boolean receiveTrafficByDefault) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUp(String clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDown(String clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.FALSE);
        }
    }

    @Deprecated
    public void setUp(Object clusterIdentifier) {
        this.setUp((String)clusterIdentifier);
    }

    @Deprecated
    public void setDown(Object clusterIdentifier) {
        this.setDown((String)clusterIdentifier);
    }

    @Deprecated
    public boolean containerShouldReceiveTraffic() {
        return this.containerShouldReceiveTraffic(Require.ONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerShouldReceiveTraffic(Require require) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.containerHasClusters) {
                switch (require) {
                    case ONE: {
                        return this.clusterStatus.values().stream().anyMatch(status -> status == true);
                    }
                }
                return !this.clusterStatus.isEmpty() && this.clusterStatus.values().stream().allMatch(status -> status == true);
            }
            return true;
        }
    }

    public static enum Require {
        ONE,
        ALL;

    }
}

