/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.log.LogLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JacksonJsonResponse<T>
extends HttpResponse {
    private static final Logger log = Logger.getLogger(JacksonJsonResponse.class.getName());
    private static final ObjectMapper defaultJsonMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module());
    private final ObjectMapper jsonMapper;
    private final T entity;

    public JacksonJsonResponse(int statusCode, T entity) {
        this(statusCode, entity, defaultJsonMapper);
    }

    public JacksonJsonResponse(int statusCode, T entity, ObjectMapper jsonMapper) {
        super(statusCode);
        this.entity = entity;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void render(OutputStream outputStream) throws IOException {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            String json = this.jsonMapper.writeValueAsString(this.entity);
            log.log((Level)LogLevel.DEBUG, "Writing the following JSON to response output stream:\n" + json);
            outputStream.write(json.getBytes());
        } else {
            this.jsonMapper.writeValue(outputStream, this.entity);
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    public T getEntity() {
        return this.entity;
    }
}

