/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.common.annotations.Beta;

public class Coverage {
    protected long docs;
    protected long active;
    protected long soonActive;
    protected int degradedReason;
    protected int nodes;
    private int nodesTried;
    protected int resultSets;
    protected int fullResultSets;
    protected FullCoverageDefinition fullReason = FullCoverageDefinition.DOCUMENT_COUNT;
    public static final int DEGRADED_BY_MATCH_PHASE = 1;
    public static final int DEGRADED_BY_TIMEOUT = 2;
    public static final int DEGRADED_BY_ADAPTIVE_TIMEOUT = 4;

    protected Coverage() {
    }

    protected Coverage(long docs, long active, int nodes, int resultSets) {
        this(docs, active, nodes, resultSets, FullCoverageDefinition.DOCUMENT_COUNT);
    }

    public Coverage(long docs, int nodes, boolean full) {
        this(docs, nodes, full, 1);
    }

    protected Coverage(long docs, int nodes, boolean full, int resultSets) {
        this(docs, docs, nodes, resultSets, full ? FullCoverageDefinition.EXPLICITLY_FULL : FullCoverageDefinition.EXPLICITLY_INCOMPLETE);
    }

    private Coverage(long docs, long active, int nodes, int resultSets, FullCoverageDefinition fullReason) {
        this.docs = docs;
        this.nodes = nodes;
        this.nodesTried = nodes;
        this.active = active;
        this.soonActive = active;
        this.degradedReason = 0;
        this.resultSets = resultSets;
        this.fullReason = fullReason;
        this.fullResultSets = this.getFull() ? resultSets : 0;
    }

    public void merge(Coverage other) {
        if (other == null) {
            return;
        }
        this.docs += other.getDocs();
        this.nodes += other.getNodes();
        this.nodesTried += other.nodesTried;
        this.active += other.getActive();
        this.soonActive += other.getSoonActive();
        this.degradedReason |= other.degradedReason;
        this.resultSets += other.getResultSets();
        this.fullResultSets += other.getFullResultSets();
        switch (other.fullReason) {
            case EXPLICITLY_FULL: {
                break;
            }
            case EXPLICITLY_INCOMPLETE: {
                this.fullReason = FullCoverageDefinition.EXPLICITLY_INCOMPLETE;
                break;
            }
            case DOCUMENT_COUNT: {
                if (this.fullReason != FullCoverageDefinition.EXPLICITLY_FULL) break;
                this.fullReason = FullCoverageDefinition.DOCUMENT_COUNT;
            }
        }
    }

    public long getDocs() {
        return this.docs;
    }

    public long getActive() {
        return this.active;
    }

    @Beta
    public long getSoonActive() {
        return this.soonActive;
    }

    public boolean isDegraded() {
        return this.degradedReason != 0 || this.isDegradedByNonIdealState();
    }

    public boolean isDegradedByMatchPhase() {
        return (this.degradedReason & 1) != 0;
    }

    public boolean isDegradedByTimeout() {
        return (this.degradedReason & 2) != 0;
    }

    public boolean isDegradedByAdapativeTimeout() {
        return (this.degradedReason & 4) != 0;
    }

    public boolean isDegradedByNonIdealState() {
        return this.degradedReason == 0 && this.getResultPercentage() != 100;
    }

    public boolean getFull() {
        switch (this.fullReason) {
            case EXPLICITLY_FULL: {
                return true;
            }
            case EXPLICITLY_INCOMPLETE: {
                return false;
            }
            case DOCUMENT_COUNT: {
                return this.docs == this.active;
            }
        }
        throw new IllegalStateException("Implementation out of sync. Please report this as a bug.");
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getNodesTried() {
        return this.nodesTried;
    }

    public Coverage setNodesTried(int nodesTried) {
        this.nodesTried = nodesTried;
        return this;
    }

    public int getFullResultSets() {
        return this.fullResultSets;
    }

    public int getResultSets() {
        return this.resultSets;
    }

    public int getResultPercentage() {
        if (this.getResultSets() == 0) {
            return 0;
        }
        if (this.docs < this.active) {
            return (int)Math.round((double)this.docs * 100.0 / (double)this.active);
        }
        return this.getFullResultSets() * 100 / this.getResultSets();
    }

    public com.yahoo.container.logging.Coverage toLoggingCoverage() {
        int degradation = com.yahoo.container.logging.Coverage.toDegradation((boolean)this.isDegradedByMatchPhase(), (boolean)this.isDegradedByTimeout(), (boolean)this.isDegradedByAdapativeTimeout());
        return new com.yahoo.container.logging.Coverage(this.getDocs(), this.getActive(), this.getSoonActive(), degradation);
    }

    protected static enum FullCoverageDefinition {
        EXPLICITLY_FULL,
        EXPLICITLY_INCOMPLETE,
        DOCUMENT_COUNT;

    }
}

