/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class QrConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "f26ba59028f4055e7e67e904ec360f6a";
    public static final String CONFIG_DEF_NAME = "qr";
    public static final String CONFIG_DEF_NAMESPACE = "container";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container", "filedistributor.configid reference default=\"\" restart", "rpc.enabled bool default=false restart", "rpc.port int default=8086 restart", "rpc.host string default=\"\" restart", "rpc.slobrokId string default=\"\" restart", "discriminator string default=\"qrserver.0\" restart", "restartOnDeploy bool default=false restart"};
    private final Filedistributor filedistributor;
    private final Rpc rpc;
    private final StringNode discriminator;
    private final BooleanNode restartOnDeploy;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public QrConfig(Builder builder) {
        this(builder, true);
    }

    private QrConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr must be initialized: " + builder.__uninitialized);
        }
        this.filedistributor = new Filedistributor(builder.filedistributor, throwIfUninitialized);
        this.rpc = new Rpc(builder.rpc, throwIfUninitialized);
        this.discriminator = builder.discriminator == null ? new StringNode("qrserver.0") : new StringNode(builder.discriminator);
        this.restartOnDeploy = builder.restartOnDeploy == null ? new BooleanNode(false) : new BooleanNode(builder.restartOnDeploy.booleanValue());
    }

    public Filedistributor filedistributor() {
        return this.filedistributor;
    }

    public Rpc rpc() {
        return this.rpc;
    }

    public String discriminator() {
        return this.discriminator.value();
    }

    public boolean restartOnDeploy() {
        return this.restartOnDeploy.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.mergeChanges("filedistributor", this.filedistributor.getChangesRequiringRestart(newConfig.filedistributor));
        changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
        changes.compare((Node)this.discriminator, (Node)newConfig.discriminator, "discriminator", "A unique identifier string for this QRS. The only guarantee given is\nthis string will be unique for every QRS in a Vespa application.");
        changes.compare((Node)this.restartOnDeploy, (Node)newConfig.restartOnDeploy, "restartOnDeploy", "Force restart of container on deploy, and defer any changes until restart");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Rpc
    extends InnerNode {
        private final BooleanNode enabled;
        private final IntegerNode port;
        private final StringNode host;
        private final StringNode slobrokId;

        public Rpc(Builder builder) {
            this(builder, true);
        }

        private Rpc(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr.rpc must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.port = builder.port == null ? new IntegerNode(8086) : new IntegerNode(builder.port.intValue());
            this.host = builder.host == null ? new StringNode(QrConfig.CONFIG_DEF_VERSION) : new StringNode(builder.host);
            this.slobrokId = builder.slobrokId == null ? new StringNode(QrConfig.CONFIG_DEF_VERSION) : new StringNode(builder.slobrokId);
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public int port() {
            return this.port.value();
        }

        public String host() {
            return this.host.value();
        }

        public String slobrokId() {
            return this.slobrokId.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
            changes.compare((Node)this.enabled, (Node)newConfig.enabled, "enabled", "Is RPC server enabled?");
            changes.compare((Node)this.port, (Node)newConfig.port, "port", "RPC server listen port");
            changes.compare((Node)this.host, (Node)newConfig.host, "host", "Which interface to bind to.");
            changes.compare((Node)this.slobrokId, (Node)newConfig.slobrokId, "slobrokId", "The id this service should register itself with in slobrok");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private Integer port = null;
            private String host = null;
            private String slobrokId = null;

            public Builder() {
            }

            public Builder(Rpc config) {
                this.enabled(config.enabled());
                this.port(config.port());
                this.host(config.host());
                this.slobrokId(config.slobrokId());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.slobrokId != null) {
                    this.slobrokId(__superior.slobrokId);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                return this;
            }

            public Builder slobrokId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.slobrokId = __value;
                return this;
            }

            public Rpc build() {
                return new Rpc(this);
            }
        }
    }

    public static final class Filedistributor
    extends InnerNode {
        private final ReferenceNode configid;

        public Filedistributor(Builder builder) {
            this(builder, true);
        }

        private Filedistributor(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr.filedistributor must be initialized: " + builder.__uninitialized);
            }
            this.configid = builder.configid == null ? new ReferenceNode(QrConfig.CONFIG_DEF_VERSION) : new ReferenceNode(builder.configid);
        }

        public String configid() {
            return this.configid.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Filedistributor newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("filedistributor");
            changes.compare((Node)this.configid, (Node)newConfig.configid, "configid", "All params must be flagged as 'restart' because this config is manually\nretrieved by ConfiguredApplication.start to init the rpc server\n\nfiledistributor rpc configuration");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String configid = null;

            public Builder() {
            }

            public Builder(Filedistributor config) {
                this.configid(config.configid());
            }

            private Builder override(Builder __superior) {
                if (__superior.configid != null) {
                    this.configid(__superior.configid);
                }
                return this;
            }

            public Builder configid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configid = __value;
                return this;
            }

            public Filedistributor build() {
                return new Filedistributor(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Filedistributor.Builder filedistributor = new Filedistributor.Builder();
        public Rpc.Builder rpc = new Rpc.Builder();
        private String discriminator = null;
        private Boolean restartOnDeploy = null;

        public Builder() {
        }

        public Builder(QrConfig config) {
            this.filedistributor(new Filedistributor.Builder(config.filedistributor()));
            this.rpc(new Rpc.Builder(config.rpc()));
            this.discriminator(config.discriminator());
            this.restartOnDeploy(config.restartOnDeploy());
        }

        private Builder override(Builder __superior) {
            this.filedistributor(this.filedistributor.override(__superior.filedistributor));
            this.rpc(this.rpc.override(__superior.rpc));
            if (__superior.discriminator != null) {
                this.discriminator(__superior.discriminator);
            }
            if (__superior.restartOnDeploy != null) {
                this.restartOnDeploy(__superior.restartOnDeploy);
            }
            return this;
        }

        public Builder filedistributor(Filedistributor.Builder __builder) {
            this.filedistributor = __builder;
            return this;
        }

        public Builder rpc(Rpc.Builder __builder) {
            this.rpc = __builder;
            return this;
        }

        public Builder discriminator(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.discriminator = __value;
            return this;
        }

        public Builder restartOnDeploy(boolean __value) {
            this.restartOnDeploy = __value;
            return this;
        }

        private Builder restartOnDeploy(String __value) {
            return this.restartOnDeploy(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrConfig.CONFIG_DEF_NAMESPACE;
        }

        public QrConfig build() {
            return new QrConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

