/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.google.inject.Inject;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class VipStatusHandler
extends ThreadedHttpRequestHandler {
    private static final Logger log = Logger.getLogger(VipStatusHandler.class.getName());
    private static final String NUM_REQUESTS_METRIC = "jdisc.http.requests.status";
    private final boolean accessDisk;
    private final File statusFile;
    private final VipStatus vipStatus;
    private volatile boolean previouslyInRotation = true;
    static final String OK_MESSAGE = "<title>OK</title>\n";
    static final byte[] VIP_OK = Utf8.toBytes((String)"<title>OK</title>\n");

    @Inject
    public VipStatusHandler(VipStatusConfig vipConfig, Metric metric, VipStatus vipStatus) {
        this(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100)), vipConfig, metric, vipStatus);
    }

    public VipStatusHandler(Executor executor, VipStatusConfig vipConfig, Metric metric) {
        this(executor, vipConfig, metric, null);
    }

    public VipStatusHandler(Executor executor, VipStatusConfig vipConfig, Metric metric, VipStatus vipStatus) {
        super(executor, metric);
        this.accessDisk = vipConfig.accessdisk();
        this.statusFile = new File(Defaults.getDefaults().underVespaHome(vipConfig.statusfile()));
        this.vipStatus = vipStatus;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        if (this.metric != null) {
            this.metric.add(NUM_REQUESTS_METRIC, (Number)1, null);
        }
        if (this.vipStatus != null) {
            this.updateAndLogRotationState();
        }
        return new StatusResponse();
    }

    private void updateAndLogRotationState() {
        boolean currentlyInRotation = this.vipStatus.isInRotation();
        boolean previousRotationAnswer = this.previouslyInRotation;
        this.previouslyInRotation = currentlyInRotation;
        if (previousRotationAnswer != currentlyInRotation) {
            if (currentlyInRotation) {
                log.log(LogLevel.INFO, "Putting container back into rotation by serving status.html again.");
            } else {
                log.log(LogLevel.WARNING, "Removing container from rotation by no longer serving status.html.");
            }
        }
    }

    class StatusResponse
    extends HttpResponse {
        static final String COULD_NOT_FIND_STATUS_FILE = "Could not find status file.\n";
        static final String NO_SEARCH_BACKENDS = "No search backends available, VIP status disabled.";
        private static final String TEXT_HTML = "text/html";
        private String contentType;
        private byte[] data;
        private File file;

        private StatusResponse() {
            super(200);
            this.contentType = TEXT_HTML;
            this.data = null;
            this.file = null;
            if (VipStatusHandler.this.vipStatus != null && !VipStatusHandler.this.vipStatus.isInRotation()) {
                this.searchContainerOutOfService();
            } else if (VipStatusHandler.this.accessDisk) {
                this.preSlurpFile();
            } else {
                this.vipRespond();
            }
        }

        @Override
        public void render(OutputStream stream) throws IOException {
            if (this.file != null) {
                this.readAndWrite(stream);
            } else if (this.data != null) {
                stream.write(this.data);
            } else {
                throw new IllegalStateException("Neither file nor hardcoded data. This is a bug, please notify the Vespa team.");
            }
            stream.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readAndWrite(OutputStream stream) throws IOException {
            int lastRead = 0;
            FileInputStream input = new FileInputStream(this.file);
            try {
                while (lastRead != -1) {
                    byte[] buffer = new byte[5000];
                    lastRead = ((InputStream)input).read(buffer);
                    if (lastRead <= 0) continue;
                    stream.write(buffer, 0, lastRead);
                }
            }
            finally {
                stream.close();
                ((InputStream)input).close();
            }
        }

        private void preSlurpFile() {
            try {
                if (!VipStatusHandler.this.statusFile.exists()) {
                    this.fileNotFound();
                    return;
                }
                if (!VipStatusHandler.this.statusFile.canRead()) {
                    this.accessDenied();
                    return;
                }
            }
            catch (SecurityException e) {
                this.internalError();
                return;
            }
            this.file = VipStatusHandler.this.statusFile;
        }

        private void accessDenied() {
            this.contentType = "text/plain";
            this.data = Utf8.toBytes((String)"Status file inaccessible.\n");
            this.setStatus(404);
        }

        private void internalError() {
            this.contentType = "text/plain";
            this.data = Utf8.toBytes((String)"Internal error while fetching status file.\n");
            this.setStatus(404);
        }

        private void fileNotFound() {
            this.contentType = "text/plain";
            this.data = Utf8.toBytes((String)COULD_NOT_FIND_STATUS_FILE);
            this.setStatus(404);
        }

        private void vipRespond() {
            this.data = VIP_OK;
        }

        private void searchContainerOutOfService() {
            this.contentType = "text/plain";
            this.data = Utf8.toBytes((String)NO_SEARCH_BACKENDS);
            this.setStatus(404);
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getCharacterEncoding() {
            return null;
        }
    }
}

