/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import java.net.URI;
import java.net.URISyntaxException;

public class Uri {
    private final URI uri;

    public Uri(URI uri) {
        this.uri = uri;
    }

    public Uri(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
    }

    public Uri append(String pathElement) {
        return new Uri(this.withoutParameters().withTrailingSlash() + pathElement);
    }

    public Uri withoutParameters() {
        int parameterStart = this.uri.toString().indexOf("?");
        if (parameterStart < 0) {
            return new Uri(this.uri.toString());
        }
        return new Uri(this.uri.toString().substring(0, parameterStart));
    }

    public Uri withPath(String path) {
        try {
            return new Uri(new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, this.uri.getQuery(), this.uri.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not add path '" + path + "' to " + this);
        }
    }

    public Uri withTrailingSlash() {
        if (this.toString().endsWith("/")) {
            return this;
        }
        return new Uri(this.toString() + "/");
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }
}

